/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.utils;

import io.fabric8.arquillian.kubernetes.Configuration;
import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.arquillian.kubernetes.log.Logger;
import io.fabric8.arquillian.utils.ConfigMaps;
import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.utils.GitHelpers;
import io.fabric8.utils.IOHelpers;
import io.fabric8.utils.Lists;
import io.fabric8.utils.MultiException;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Util {
    public static String readAsString(URL url) {
        try {
            return IOHelpers.readFully((URL)url);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void displaySessionStatus(KubernetesClient client, Session session) throws MultiException {
        List pods;
        if (client == null) {
            session.getLogger().warn("No KubernetesClient for session: " + session.getId());
            return;
        }
        if (client.isAdaptable(OpenShiftClient.class).booleanValue()) {
            OpenShiftClient oClient = (OpenShiftClient)client.adapt(OpenShiftClient.class);
            List deploymentConfigs = ((DeploymentConfigList)((NonNamespaceOperation)oClient.deploymentConfigs().inNamespace(session.getNamespace())).list()).getItems();
            if (deploymentConfigs == null) {
                throw new MultiException("No deployment configs found in namespace" + session.getNamespace());
            }
            Iterator iterator = deploymentConfigs.iterator();
            while (iterator.hasNext()) {
                DeploymentConfig deploymentConfig = (DeploymentConfig)iterator.next();
                session.getLogger().info("Deployment config:" + KubernetesHelper.getName((HasMetadata)deploymentConfig));
            }
        } else {
            List deployments = ((DeploymentList)((NonNamespaceOperation)client.extensions().deployments().inNamespace(session.getNamespace())).list()).getItems();
            if (deployments == null) {
                throw new MultiException("No deployments found in namespace" + session.getNamespace());
            }
            for (Deployment deployment : deployments) {
                session.getLogger().info("Deployment:" + KubernetesHelper.getName((HasMetadata)deployment));
            }
        }
        if ((pods = ((PodList)((NonNamespaceOperation)client.pods().inNamespace(session.getNamespace())).list()).getItems()) == null) {
            throw new MultiException("No pods found in namespace" + session.getNamespace());
        }
        for (Pod pod : pods) {
            session.getLogger().info("Pod:" + KubernetesHelper.getName((HasMetadata)pod) + " Status:" + pod.getStatus());
        }
        List svcs = ((ServiceList)((NonNamespaceOperation)client.services().inNamespace(session.getNamespace())).list()).getItems();
        if (svcs == null) {
            throw new MultiException("No services found in namespace" + session.getNamespace());
        }
        for (Service service : svcs) {
            session.getLogger().info("Service:" + KubernetesHelper.getName((HasMetadata)service) + " IP:" + KubernetesHelper.getPortalIP((Service)service) + " Port:" + KubernetesHelper.getPorts((Service)service));
        }
    }

    public static void cleanupSession(KubernetesClient client, Controller controller, Configuration configuration, Session session, String status) throws MultiException {
        if (configuration.isNamespaceCleanupEnabled()) {
            Util.waitUntilWeCanDestroyNamespace(session);
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            Util.cleanupAllMatching(client, session, errors);
            if (configuration.isCreateNamespaceForTest()) {
                try {
                    controller.deleteNamespace(session.getNamespace());
                }
                catch (Exception e) {
                    errors.add(e);
                }
            }
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
            for (Throwable exception : errors) {
                if (exception instanceof KubernetesClientException && ((KubernetesClientException)exception).getCode() == 403) {
                    session.getLogger().warn(exception.getMessage());
                    continue;
                }
                exceptions.add(exception);
            }
            if (!exceptions.isEmpty()) {
                throw new MultiException("Error while cleaning up session.", exceptions);
            }
        } else {
            ConfigMaps.updateConfigMapStatus(client, session, status);
        }
    }

    protected static void waitUntilWeCanDestroyNamespace(Session session) {
        Logger log = session.getLogger();
        String confirmDestroy = Systems.getEnvVarOrSystemProperty((String)"namespace.cleanup.confirm.enabled", (String)"false");
        if (Objects.equal((Object)confirmDestroy, (Object)"true")) {
            Util.showErrorsBeforePause(session);
            System.out.println();
            System.out.println("Waiting to destroy the namespace.");
            System.out.println("Please type: [Q] to terminate the namespace.");
            try {
                while (true) {
                    int ch;
                    if ((ch = System.in.read()) < 0 || ch == 81) {
                        System.out.println("\nStopping...");
                    }
                    System.out.println("Found character: " + Character.toString((char)ch));
                }
            }
            catch (IOException e) {
                log.warn("Failed to read from input. " + e);
            }
        } else {
            String timeoutText = Systems.getEnvVarOrSystemProperty((String)"namespace.cleanup.timeout", (String)"0");
            Long timeout = null;
            if (Strings.isNotBlank((String)timeoutText)) {
                try {
                    timeout = Long.parseLong(timeoutText);
                }
                catch (NumberFormatException e) {
                    log.warn("Failed to parse timeout value '" + timeoutText + "' for $Constants.NAMESPACE_CLEANUP_TIMEOUT. " + e);
                }
            }
            if (timeout != null && timeout > 0L) {
                Util.showErrorsBeforePause(session);
                System.out.println();
                System.out.println("Sleeping for " + timeout + " seconds until destroying the namespace");
                try {
                    Thread.sleep(timeout * 1000L);
                }
                catch (InterruptedException e) {
                    log.info("Interupted sleeping to GC the namespace: " + e);
                }
            }
        }
        System.out.println("Now destroying the Fabric8 Arquillian test case namespace");
    }

    protected static void showErrorsBeforePause(Session session) {
    }

    public static void cleanupAllMatching(KubernetesClient client, Session session, List<Throwable> errors) throws MultiException {
        for (int i = 0; i < 10; ++i) {
            OpenShiftClient openShiftClient = new Controller(client).getOpenShiftClientOrNull();
            String sessionNamespace = session.getNamespace();
            if (openShiftClient != null) {
                try {
                    ((NonNamespaceOperation)openShiftClient.deploymentConfigs().inNamespace(sessionNamespace)).delete();
                }
                catch (KubernetesClientException e) {
                    errors.add(e);
                }
                try {
                    ((NonNamespaceOperation)openShiftClient.routes().inNamespace(sessionNamespace)).delete();
                }
                catch (KubernetesClientException e) {
                    errors.add(e);
                }
            }
            try {
                ((NonNamespaceOperation)client.extensions().deployments().inNamespace(sessionNamespace)).delete();
            }
            catch (KubernetesClientException e) {
                errors.add(e);
            }
            try {
                ((NonNamespaceOperation)client.extensions().replicaSets().inNamespace(sessionNamespace)).delete();
            }
            catch (KubernetesClientException e) {
                errors.add(e);
            }
            try {
                ((NonNamespaceOperation)client.replicationControllers().inNamespace(sessionNamespace)).delete();
            }
            catch (KubernetesClientException e) {
                errors.add(e);
            }
            try {
                ((NonNamespaceOperation)client.pods().inNamespace(sessionNamespace)).delete();
            }
            catch (KubernetesClientException e) {
                errors.add(e);
            }
            try {
                ((NonNamespaceOperation)client.extensions().ingresses().inNamespace(sessionNamespace)).delete();
            }
            catch (KubernetesClientException e) {
                errors.add(e);
            }
            try {
                ((NonNamespaceOperation)client.services().inNamespace(sessionNamespace)).delete();
            }
            catch (KubernetesClientException e) {
                errors.add(e);
            }
            try {
                ((Resource)client.securityContextConstraints().withName(sessionNamespace)).delete();
            }
            catch (KubernetesClientException e) {
                errors.add(e);
            }
            List filteredPods = Lists.notNullList((List)((PodList)((NonNamespaceOperation)client.pods().inNamespace(sessionNamespace)).list()).getItems());
            if (filteredPods.isEmpty()) {
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static String findGitUrl(Session session, File dir) {
        try {
            return GitHelpers.extractGitUrl((File)dir);
        }
        catch (IOException e) {
            session.getLogger().warn("Could not detect git url from directory: " + dir + ". " + e);
            return null;
        }
    }

    public static File getProjectBaseDir(Session session) {
        String basedir = System.getProperty("basedir", ".");
        return new File(basedir);
    }

    public static String getSessionStatus(Session session) {
        if (session.getFailed().get() > 0) {
            return "FAILED";
        }
        return "PASSED";
    }
}

