/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.utils;

import io.fabric8.arquillian.kubernetes.Configuration;
import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Namespaces {
    private static final transient Logger LOG = LoggerFactory.getLogger(Namespaces.class);

    public static void createNamespace(KubernetesClient client, Controller controller, Session session) {
        String newNamespace = session.getNamespace();
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("project", client.getNamespace());
        labels.put("provider", "fabric8");
        labels.put("component", "integrationTest");
        labels.put("framework", "arquillian");
        controller.applyNamespace(newNamespace, labels);
    }

    public static void checkNamespace(KubernetesClient client, Controller controller, Session session, Configuration configuration) {
        boolean exists = controller.checkNamespace(session.getNamespace());
        if (exists) {
            return;
        }
        if (!configuration.isNamespaceLazyCreateEnabled()) {
            throw new IllegalStateException("Namespace " + session.getNamespace() + " doesn't exists");
        }
        Namespaces.createNamespace(client, controller, session);
    }
}

