/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes.enricher;

import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.arquillian.kubernetes.enricher.EnricherUtils;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;

public class ReplicationControllerListResourceProvider
implements ResourceProvider {
    @Inject
    private Instance<KubernetesClient> clientInstance;
    @Inject
    private Instance<Session> sessionInstance;

    public boolean canProvide(Class<?> type) {
        return ReplicationControllerList.class.isAssignableFrom(type);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        KubernetesClient client = (KubernetesClient)this.clientInstance.get();
        Session session = (Session)this.sessionInstance.get();
        Map<String, String> labels = EnricherUtils.getLabels(qualifiers);
        if (labels.isEmpty()) {
            return ((NonNamespaceOperation)client.replicationControllers().inNamespace(session.getNamespace())).list();
        }
        return ((FilterWatchListDeletable)((NonNamespaceOperation)client.replicationControllers().inNamespace(session.getNamespace())).withLabels(labels)).list();
    }
}

