/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes.enricher;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;

public class ClientResourceProvider
implements ResourceProvider {
    @Inject
    private Instance<KubernetesClient> kubernetesClient;

    public boolean canProvide(Class<?> type) {
        return KubernetesClient.class.isAssignableFrom(type);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        KubernetesClient client = (KubernetesClient)this.kubernetesClient.get();
        if (client == null) {
            throw new IllegalStateException("Unable to inject Kubernetes client into test.");
        }
        return client;
    }
}

