/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes.await;

import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.PodStatusType;
import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.kubernetes.api.model.ContainerStateWaiting;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.utils.Objects;
import java.util.List;
import java.util.concurrent.Callable;

public class SessionPodsAreReady
implements Callable<Boolean> {
    private final Session session;
    private final KubernetesClient kubernetesClient;

    public SessionPodsAreReady(KubernetesClient kubernetesClient, Session session) {
        this.session = session;
        this.kubernetesClient = kubernetesClient;
    }

    @Override
    public Boolean call() throws Exception {
        boolean result = true;
        List pods = ((PodList)((ClientNonNamespaceOperation)this.kubernetesClient.pods().inNamespace(this.session.getNamespace())).list()).getItems();
        if (pods.isEmpty()) {
            result = false;
            this.session.getLogger().warn("No pods are available yet, waiting...");
        }
        for (Pod pod : pods) {
            PodStatus podStatus;
            if ((result = result && Objects.equal((Object)PodStatusType.OK, (Object)KubernetesHelper.getPodStatus((Pod)pod))) || (podStatus = pod.getStatus()) == null) continue;
            List containerStatuses = podStatus.getContainerStatuses();
            for (ContainerStatus containerStatus : containerStatuses) {
                ContainerStateWaiting waiting;
                ContainerState state = containerStatus.getState();
                if (state == null || (waiting = state.getWaiting()) == null) continue;
                String containerName = containerStatus.getName();
                this.session.getLogger().warn("Waiting for container:" + containerName + ". Reason:" + waiting.getReason());
            }
        }
        return result;
    }
}

