/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes;

import io.fabric8.arquillian.kubernetes.log.Logger;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.utils.GitHelpers;
import io.fabric8.utils.PropertiesHelper;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class Session {
    private final String id;
    private final Logger logger;
    private String namespacePrefix = "itest-";
    private String namespace;
    private Namespace namespaceDetails;

    public Session(String id, Logger logger) {
        File pomProperties;
        this.id = id;
        this.logger = logger;
        this.namespacePrefix = Systems.getEnvVarOrSystemProperty((String)"FABRIC8_NAMESPACE_PREFIX", (String)"itest-");
        this.namespace = this.namespacePrefix + id;
        this.namespaceDetails = new Namespace();
        KubernetesHelper.getOrCreateMetadata((HasMetadata)this.namespaceDetails).setName(this.namespace);
        Map labels = KubernetesHelper.getOrCreateLabels((HasMetadata)this.namespaceDetails);
        labels.put("provider", "fabric8");
        labels.put("component", "integrationTest");
        labels.put("framework", "arquillian");
        Map annotations = KubernetesHelper.getOrCreateAnnotations((HasMetadata)this.namespaceDetails);
        annotations.put("fabric8.devops/arquillianId", id);
        File dir = this.getBaseDir();
        String gitUrl = this.findGitUrl(dir);
        if (Strings.isNotBlank((String)gitUrl)) {
            annotations.put("fabric8.devops/gitUrl", gitUrl);
        }
        if ((pomProperties = new File(dir, "target/maven-archiver/pom.properties")).isFile()) {
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(pomProperties));
                Map map = PropertiesHelper.toMap((Properties)properties);
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (!Strings.isNotBlank((String)key) || !Strings.isNotBlank((String)value)) continue;
                    annotations.put("fabric8.devops/" + key, value);
                }
            }
            catch (IOException e) {
                logger.warn("Failed to load " + pomProperties + " file to annotate the namespace: " + e);
            }
        }
    }

    void init() {
        this.logger.status("Initializing Session:" + this.id);
    }

    void destroy() {
        this.logger.status("Destroying Session:" + this.id);
        System.out.flush();
    }

    public String getId() {
        return this.id;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Namespace getNamespaceDetails() {
        return this.namespaceDetails;
    }

    protected String findGitUrl(File dir) {
        try {
            return GitHelpers.extractGitUrl((File)dir);
        }
        catch (IOException e) {
            this.logger.warn("Could not detect git url from directory: " + dir + ". " + e);
            return null;
        }
    }

    protected File getBaseDir() {
        String basedir = System.getProperty("basedir", ".");
        return new File(basedir);
    }
}

