/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes;

import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Configuration {
    private static final Long DEFAULT_TIMEOUT = 300000L;
    private static final Long DEFAULT_POLL_INTERVAL = 5000L;
    private static final Long DEFAULT_SERVICE_CONNECTION_TIMEOUT = 10000L;
    private static final boolean DEFAULT_CONNECT_TO_SERVICES = false;
    private String masterUrl;
    private List<String> dependencies = new ArrayList<String>();
    private URL configUrl;
    private long timeout = DEFAULT_TIMEOUT;
    private long pollInterval = DEFAULT_POLL_INTERVAL;
    private boolean ansiLoggerEnabled = true;
    private boolean connectToServices = false;
    private List<String> waitForServices = new ArrayList<String>();
    private boolean waitForServiceConnection = false;
    private Long serviceConnectionTimeout = DEFAULT_SERVICE_CONNECTION_TIMEOUT;
    private Map<String, String> properties;

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getMasterUrl() {
        return this.masterUrl;
    }

    public URL getConfigUrl() {
        return this.configUrl;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public long getPollInterval() {
        return this.pollInterval;
    }

    public boolean isAnsiLoggerEnabled() {
        return this.ansiLoggerEnabled;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public boolean isWaitForServiceConnection() {
        return this.waitForServiceConnection;
    }

    public List<String> getWaitForServices() {
        return this.waitForServices;
    }

    public int getServiceConnectionTimeout() {
        return this.serviceConnectionTimeout.intValue();
    }

    public boolean isConnectToServices() {
        return this.connectToServices;
    }

    public void setConnectToServices(boolean connectToServices) {
        this.connectToServices = connectToServices;
    }

    public static Configuration fromMap(Map<String, String> map) {
        Configuration configuration = new Configuration();
        try {
            Configuration.applyMasterUrl(configuration, map);
            Configuration.applyConfigurationURL(configuration, map);
            Configuration.applyDependencies(configuration, map);
            configuration.timeout = Configuration.getLongProperty("timeout", map, DEFAULT_TIMEOUT);
            configuration.pollInterval = Configuration.getLongProperty("pollInterval", map, DEFAULT_POLL_INTERVAL);
            configuration.ansiLoggerEnabled = Configuration.getBooleanProperty("ansi.logger.enabled", map, true);
            configuration.waitForServiceConnection = Configuration.getBooleanProperty("waitForServiceConnection", map, true);
            configuration.waitForServices = Strings.splitAndTrimAsList((String)Configuration.getStringProperty("waitForServices", map, ""), (String)" ");
            configuration.connectToServices = Configuration.getBooleanProperty("connectToServices", map, false);
            configuration.serviceConnectionTimeout = Configuration.getLongProperty("serviceConnectionTimeout", map, DEFAULT_SERVICE_CONNECTION_TIMEOUT);
            configuration.properties = map;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return configuration;
    }

    private static void applyMasterUrl(Configuration configuration, Map<String, String> map) {
        if (map.containsKey("masterUrl")) {
            configuration.masterUrl = map.get("masterUrl");
        }
    }

    private static void applyConfigurationURL(Configuration configuration, Map<String, String> map) throws MalformedURLException {
        configuration.configUrl = map.containsKey("configUrl") ? new URL(map.get("configUrl")) : (map.containsKey("configFileName") ? Configuration.class.getResource("/" + map.get("configFileName")) : Configuration.class.getResource("/kubernetes.json"));
    }

    private static void applyDependencies(Configuration configuration, Map<String, String> map) throws MalformedURLException {
        if (map.containsKey("dependencies")) {
            configuration.dependencies = Strings.splitAndTrimAsList((String)map.get("dependencies"), (String)" ");
        }
    }

    private static String getStringProperty(String name, Map<String, String> map, String defaultValue) {
        if (map.containsKey(name)) {
            return map.get(name);
        }
        return Systems.getEnvVarOrSystemProperty((String)name, (String)defaultValue);
    }

    private static Boolean getBooleanProperty(String name, Map<String, String> map, Boolean defaultValue) {
        if (map.containsKey(name)) {
            return Boolean.parseBoolean(map.get(name));
        }
        return Systems.getEnvVarOrSystemProperty((String)name, (Boolean)defaultValue);
    }

    private static Long getLongProperty(String name, Map<String, String> map, Long defaultValue) {
        if (map.containsKey(name)) {
            return Long.parseLong(map.get(name));
        }
        return Systems.getEnvVarOrSystemProperty((String)name, (Number)defaultValue).longValue();
    }
}

