/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.utils;

import io.fabric8.arquillian.kubernetes.Configuration;
import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.arquillian.utils.Util;
import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.model.DoneableNamespace;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.utils.PropertiesHelper;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Namespaces {
    private static final transient Logger LOG = LoggerFactory.getLogger(Namespaces.class);

    public static void createNamespace(KubernetesClient client, Controller controller, Session session) {
        String newNamespace = session.getNamespace();
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("project", client.getNamespace());
        labels.put("provider", "fabric8");
        labels.put("component", "integrationTest");
        labels.put("framework", "arquillian");
        controller.applyNamespace(newNamespace, labels);
    }

    public static void checkNamespace(KubernetesClient client, Controller controller, Session session, Configuration configuration) {
        Namespace result = (Namespace)((ClientResource)client.namespaces().withName(session.getNamespace())).get();
        if (result != null) {
            return;
        }
        if (!configuration.isNamespaceLazyCreateEnabled()) {
            throw new IllegalStateException("Namespace " + session.getNamespace() + "doesn't exists");
        }
        Namespaces.createNamespace(client, controller, session);
    }

    public static synchronized Namespace updateNamespaceStatus(KubernetesClient client, Session session, String status) {
        try {
            return ((DoneableNamespace)((NamespaceFluent.MetadataNested)((DoneableNamespace)((ClientResource)client.namespaces().withName(session.getNamespace())).edit()).editMetadata().addToAnnotations(Namespaces.createNamespaceAnnotations(session, status))).endMetadata()).done();
        }
        catch (Exception e) {
            LOG.warn("failed to update namespace: " + e, (Throwable)e);
            return null;
        }
    }

    public static synchronized Namespace updateNamespaceTestStatus(KubernetesClient client, Session session, String test, String status) {
        try {
            return ((DoneableNamespace)((NamespaceFluent.MetadataNested)((DoneableNamespace)((ClientResource)client.namespaces().withName(session.getNamespace())).edit()).editMetadata().addToAnnotations("fabric8.io/test-status-" + test, status)).endMetadata()).done();
        }
        catch (Exception e) {
            LOG.warn("failed to update namespace: " + e, (Throwable)e);
            return null;
        }
    }

    private static Map<String, String> createNamespaceAnnotations(Session session, String status) {
        File pomProperties;
        HashMap<String, String> annotations = new HashMap<String, String>();
        File dir = Util.getProjectBaseDir(session);
        String gitUrl = Util.findGitUrl(session, dir);
        annotations.put("fabric8.io/test-session-id", session.getId());
        annotations.put("fabric8.io/test-session-status", status);
        if (Strings.isNotBlank((String)gitUrl)) {
            annotations.put("fabric8.io/git-url", gitUrl);
        }
        if ((pomProperties = new File(dir, "target/maven-archiver/pom.properties")).isFile()) {
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(pomProperties));
                Map map = PropertiesHelper.toMap((Properties)properties);
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (!Strings.isNotBlank((String)key) || !Strings.isNotBlank((String)value)) continue;
                    annotations.put("fabric8.io/project-" + key, value);
                }
            }
            catch (IOException e) {
                session.getLogger().warn("Failed to load " + pomProperties + " file to annotate the namespace: " + e);
            }
        }
        return annotations;
    }
}

