/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes;

import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.arquillian.utils.Namespaces;
import io.fabric8.kubernetes.client.KubernetesClient;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.test.spi.event.suite.AfterTestLifecycleEvent;
import org.jboss.arquillian.test.spi.event.suite.BeforeTestLifecycleEvent;

public class TestListener {
    private static final int MAX_ANNOTATION_KEY_LENGTH = 63;

    public void start(@Observes(precedence=-2147483648) BeforeTestLifecycleEvent event, KubernetesClient client, Session session) {
        String pkg = event.getTestClass().getJavaClass().getPackage().getName();
        String className = event.getTestClass().getJavaClass().getSimpleName();
        String methodName = event.getTestMethod().getName();
        Namespaces.updateNamespaceTestStatus(client, session, TestListener.trimName(pkg, className, methodName), "RUNNING");
    }

    public void stop(@Observes(precedence=-2147483648) AfterTestLifecycleEvent event, TestResult result, KubernetesClient client, Session session) {
        String pkg = event.getTestClass().getJavaClass().getPackage().getName();
        String className = event.getTestClass().getJavaClass().getSimpleName();
        String methodName = event.getTestMethod().getName();
        Namespaces.updateNamespaceTestStatus(client, session, TestListener.trimName(pkg, className, methodName), result.getStatus().name());
        switch (result.getStatus()) {
            case PASSED: {
                session.getPassed().incrementAndGet();
                break;
            }
            case FAILED: {
                session.getFailed().incrementAndGet();
                break;
            }
            case SKIPPED: {
                session.getSkiped().incrementAndGet();
            }
        }
    }

    static String trimName(String packageName, String className, String methodName) {
        StringBuilder sb = new StringBuilder();
        sb.append(TestListener.trimPackage(packageName)).append(".").append(className).append(".").append(methodName);
        String result = sb.toString();
        int prefixLength = "fabric8.io/test-status-".length();
        if (prefixLength + result.length() > 63) {
            result = result.substring(prefixLength + result.length() - 63);
        }
        if (result.charAt(0) == '.') {
            result = result.substring(1);
        }
        return result;
    }

    static String trimPackage(String pkg) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String part : pkg.split("\\.")) {
            if (first) {
                first = false;
            } else {
                sb.append(".");
            }
            sb.append(part.substring(0, 1));
        }
        return sb.toString();
    }
}

