/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes;

import io.fabric8.arquillian.kubernetes.log.Logger;
import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;

public class Session {
    private final String id;
    private final Logger logger;
    private final String namespace;
    private final AtomicInteger passed = new AtomicInteger();
    private final AtomicInteger failed = new AtomicInteger();
    private final AtomicInteger skiped = new AtomicInteger();
    private File basedir;

    public Session(String id, String namespace, Logger logger) {
        this.id = id;
        this.logger = logger;
        this.namespace = namespace;
    }

    void init() {
        this.logger.status("Initializing Session:" + this.id);
    }

    void destroy() {
        this.logger.status("Destroying Session:" + this.id);
        System.out.flush();
    }

    public String getId() {
        return this.id;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public AtomicInteger getPassed() {
        return this.passed;
    }

    public AtomicInteger getFailed() {
        return this.failed;
    }

    public AtomicInteger getSkiped() {
        return this.skiped;
    }

    public File getBaseDir() {
        if (this.basedir == null) {
            this.basedir = new File(System.getProperty("basedir", "."));
        }
        return this.basedir;
    }
}

