/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zeroconf;

import io.fabric8.api.FabricService;
import io.fabric8.zeroconf.JmDNSFactory;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroConfBridge {
    private static final transient Logger LOG = LoggerFactory.getLogger(ZeroConfBridge.class);
    private final CopyOnWriteArrayList<ServiceInfo> serviceInfos = new CopyOnWriteArrayList();
    private JmDNS jmdns;
    private InetAddress localAddress;
    private String localhost;
    private int weight;
    private int priority;
    private CuratorFramework curator;
    private FabricService fabricService;
    private boolean doList = true;
    private String[] types = new String[]{"_graphite._tcp.local.", "_ganglia._tcp.local."};

    public void start() throws Exception {
        this.getJmdns();
        ServiceListener listener = new ServiceListener(){

            @Override
            public void serviceAdded(ServiceEvent event) {
                ZeroConfBridge.this.log("Added", event);
                JmDNS dns = event.getDNS();
                String type = event.getType();
                String name = event.getName();
                dns.requestServiceInfo(type, name);
                ServiceInfo info = dns.getServiceInfo(type, name);
                if (info != null) {
                    ZeroConfBridge.this.addToZooKeeper(info);
                }
            }

            @Override
            public void serviceRemoved(ServiceEvent event) {
                ZeroConfBridge.this.log("Removed", event);
                ZeroConfBridge.this.removeFromZooKeper(event);
            }

            @Override
            public void serviceResolved(ServiceEvent event) {
                ZeroConfBridge.this.log("Resolved", event);
                ServiceInfo info = event.getInfo();
                if (info != null) {
                    ZeroConfBridge.this.addToZooKeeper(info);
                }
            }
        };
        for (String type : this.getTypes()) {
            LOG.info("Listening for ZeroConf services of type: " + type);
            this.jmdns.addServiceListener(type, listener);
        }
        if (this.doList) {
            for (String type : this.getTypes()) {
                ServiceInfo[] list = this.jmdns.list(type);
                if (list == null) continue;
                for (ServiceInfo info : list) {
                    this.addToZooKeeper(info);
                }
            }
        }
    }

    public void stop() {
        if (this.jmdns != null) {
            for (ServiceInfo si : this.serviceInfos) {
                this.jmdns.unregisterService(si);
            }
            final JmDNS closeTarget = this.jmdns;
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        if (JmDNSFactory.onClose(ZeroConfBridge.this.getLocalAddress())) {
                            closeTarget.close();
                        }
                    }
                    catch (IOException e) {
                        LOG.debug("Error closing JmDNS " + ZeroConfBridge.this.getLocalhost() + ". This exception will be ignored.", (Throwable)e);
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
            this.jmdns = null;
        }
    }

    public void registerService(String name, int port, String type) throws IOException {
        ServiceInfo si = this.createServiceInfo(name, new HashMap(), port, type);
        this.registerService(si);
    }

    public void registerService(ServiceInfo si) throws IOException {
        this.serviceInfos.add(si);
        this.getJmdns().registerService(si);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public JmDNS getJmdns() throws IOException {
        if (this.jmdns == null) {
            this.jmdns = this.createJmDNS();
        }
        return this.jmdns;
    }

    public void setJmdns(JmDNS jmdns) {
        this.jmdns = jmdns;
    }

    public InetAddress getLocalAddress() throws UnknownHostException {
        if (this.localAddress == null) {
            this.localAddress = this.createLocalAddress();
        }
        return this.localAddress;
    }

    public void setLocalAddress(InetAddress localAddress) {
        this.localAddress = localAddress;
    }

    public String getLocalhost() {
        return this.localhost;
    }

    public void setLocalhost(String localhost) {
        this.localhost = localhost;
    }

    public String[] getTypes() {
        return this.types;
    }

    public void setTypes(String[] types) {
        this.types = types;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public void setCurator(CuratorFramework curator) {
        this.curator = curator;
    }

    private void addToZooKeeper(ServiceInfo info) {
        String type = info.getType();
        String server = info.getServer();
        int port = info.getPort();
        String name = info.getName();
        LOG.debug("Found: " + type + " " + name + " => " + server + ":" + port);
        this.addToZooKeeper(type, name, server, port);
    }

    protected void addToZooKeeper(String type, String name, String server, int port) {
        String id = name.replace(' ', '-');
        String key = "/fabric/registry/clusters/stats/" + id + ".properties";
        Properties properties = new Properties();
        properties.setProperty("name", name);
        properties.setProperty("zeroConfType", type);
        properties.setProperty("host", server);
        properties.setProperty("port", "" + port);
        CuratorFramework zk = this.getCurator();
        if (zk == null) {
            LOG.warn("No ZooKeeper client set so cannot write entry " + key + " with properties: " + properties);
        } else {
            try {
                LOG.info("Writing to ZK + " + key + " ZeroConf properties " + properties);
                StringWriter buffer = new StringWriter();
                String comments = "Generated by fabric-zeroconf";
                properties.store(buffer, comments);
                String data = buffer.toString();
                ZooKeeperUtils.setData((CuratorFramework)zk, (String)key, (String)data);
            }
            catch (Exception e) {
                LOG.warn("Failed to write entry " + key + "to ZooKeeper: " + e, (Throwable)e);
            }
        }
    }

    protected void removeFromZooKeper(ServiceEvent event) {
    }

    protected void log(String message, ServiceEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(message + ": " + event.getType() + " : " + event.getName());
        }
        LOG.info(message + ": " + event.getType() + " : " + event.getName());
    }

    protected ServiceInfo createServiceInfo(String name, Map map, int port, String type) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registering service type: " + type + " name: " + name + " details: " + map);
        }
        return ServiceInfo.create(type, name + "." + type, port, this.weight, this.priority, "");
    }

    protected JmDNS createJmDNS() throws IOException {
        return JmDNSFactory.create(this.getLocalAddress());
    }

    protected InetAddress createLocalAddress() throws UnknownHostException {
        if (this.localhost != null) {
            return InetAddress.getByName(this.localhost);
        }
        return InetAddress.getLocalHost();
    }
}

