/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.platform.impl.resolver;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClient;
import org.vertx.java.core.http.HttpClientRequest;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.json.impl.Base64;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.platform.impl.ModuleIdentifier;

public abstract class HttpResolution {
    private static final Logger log = LoggerFactory.getLogger(HttpResolution.class);
    private static final String HTTP_PROXY_HOST_PROP_NAME = "http.proxyHost";
    private static final String HTTP_PROXY_PORT_PROP_NAME = "http.proxyPort";
    private static final String HTTP_BASIC_AUTH_USER_PROP_NAME = "http.authUser";
    private static final String HTTP_BASIC_AUTH_PASSWORD_PROP_NAME = "http.authPass";
    public static boolean suppressDownloadCounter = true;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final Vertx vertx;
    protected final String repoHost;
    protected final int repoPort;
    protected final String repoScheme;
    protected final String repoPassword;
    protected final String repoUsername;
    protected final ModuleIdentifier modID;
    protected final String filename;
    protected final String proxyHost = HttpResolution.getProxyHost();
    protected final int proxyPort = HttpResolution.getProxyPort();
    private final Map<Integer, Handler<HttpClientResponse>> handlers = new HashMap<Integer, Handler<HttpClientResponse>>();
    protected HttpClient client;
    private boolean result;

    public boolean waitResult() {
        while (true) {
            try {
                if (!this.latch.await(3600L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("Timed out waiting to download module");
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        return this.result;
    }

    public HttpResolution(Vertx vertx, String repoScheme, String repoUsername, String repoPassword, String repoHost, int repoPort, ModuleIdentifier modID, String filename) {
        this.vertx = vertx;
        this.repoHost = repoHost;
        this.repoPort = repoPort;
        this.repoUsername = repoUsername;
        this.repoPassword = repoPassword;
        this.modID = modID;
        this.filename = filename;
        this.repoScheme = repoScheme;
    }

    protected HttpClient createClient(String scheme, String host, int port) {
        if (this.client != null) {
            throw new IllegalStateException("Client already created");
        }
        this.client = this.vertx.createHttpClient();
        this.client.setKeepAlive(false);
        if (this.proxyHost != null) {
            this.client.setHost(this.proxyHost);
            if (this.proxyPort != 80) {
                this.client.setPort(this.proxyPort);
            } else {
                this.client.setPort(80);
            }
        } else {
            this.client.setHost(host);
            this.client.setPort(port);
        }
        if (scheme.equals("https")) {
            this.client.setSSL(true);
        }
        this.client.exceptionHandler(new Handler<Throwable>(){

            @Override
            public void handle(Throwable t) {
                HttpResolution.this.end(false);
            }
        });
        return this.client;
    }

    protected void sendRequest(String scheme, String host, int port, String uri, Handler<HttpClientResponse> respHandler) {
        String proxyHost = HttpResolution.getProxyHost();
        if (proxyHost != null) {
            uri = scheme + "://" + host + ":" + port + uri;
        }
        HttpClientRequest req = this.client.get(uri, respHandler);
        if (proxyHost != null) {
            req.putHeader("host", proxyHost);
        } else {
            req.putHeader("host", host);
        }
        if (this.getBasicAuth() != null) {
            log.debug("Using HTTP Basic Authorization");
            req.putHeader("Authorization", "Basic " + this.getBasicAuth());
        }
        req.putHeader("user-agent", "Vert.x Module Installer");
        req.end();
    }

    protected abstract void getModule();

    protected void makeRequest(String scheme, String host, int port, String uri) {
        this.sendRequest(scheme, host, port, uri, new Handler<HttpClientResponse>(){

            @Override
            public void handle(HttpClientResponse resp) {
                Handler handler = (Handler)HttpResolution.this.handlers.get(resp.statusCode());
                if (handler != null) {
                    handler.handle(resp);
                } else {
                    HttpResolution.this.end(false);
                }
            }
        });
    }

    protected void end(boolean ok) {
        this.client.close();
        this.result = ok;
        this.latch.countDown();
    }

    protected void addHandler(int statusCode, Handler<HttpClientResponse> handler) {
        this.handlers.put(statusCode, handler);
    }

    protected void removeHandler(int statusCode) {
        this.handlers.remove(statusCode);
    }

    protected void downloadToFile(String file, HttpClientResponse resp) {
        BufferedOutputStream os;
        log.info("Downloading " + this.modID + ". Please wait...");
        try {
            os = new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (IOException e) {
            log.error("Failed to open file", e);
            this.end(false);
            return;
        }
        final AtomicInteger written = new AtomicInteger();
        final int contentLength = Integer.valueOf(resp.headers().get("content-length"));
        resp.dataHandler(new Handler<Buffer>(){
            long lastPercent = 0L;

            @Override
            public void handle(Buffer data) {
                int bytesWritten = written.get();
                try {
                    os.write(data.getBytes());
                }
                catch (IOException e) {
                    log.error("Failed to write to file", e);
                    HttpResolution.this.end(false);
                    return;
                }
                if (!suppressDownloadCounter) {
                    written.addAndGet(data.length());
                    long percent = Math.round(100.0 * (double)bytesWritten / (double)contentLength);
                    if (percent > this.lastPercent) {
                        System.out.print("\rDownloading " + percent + "%");
                        this.lastPercent = percent;
                    }
                }
            }
        });
        resp.endHandler(new VoidHandler(){

            @Override
            protected void handle() {
                if (!suppressDownloadCounter) {
                    System.out.println("\rDownloading 100%");
                }
                try {
                    os.close();
                    HttpResolution.this.end(true);
                }
                catch (IOException e) {
                    log.error("Failed to flush file", e);
                    HttpResolution.this.end(false);
                }
            }
        });
    }

    protected void handleRedirect(HttpClientResponse resp) {
        String location = resp.headers().get("location");
        if (location == null) {
            log.error("HTTP redirect with no location header");
        } else {
            try {
                URI redirectURI = new URI(location);
                this.client.close();
                this.client = null;
                int redirectPort = redirectURI.getPort();
                if (redirectPort == -1) {
                    redirectPort = 80;
                }
                String uri = redirectURI.getRawPath();
                String query = redirectURI.getRawQuery();
                if (query != null) {
                    uri = uri + "?" + query;
                }
                this.createClient(redirectURI.getScheme(), redirectURI.getHost(), redirectPort);
                this.makeRequest(redirectURI.getScheme(), redirectURI.getHost(), redirectPort, uri);
            }
            catch (URISyntaxException e) {
                log.error("Invalid redirect URI: " + location);
            }
        }
    }

    protected void addRedirectHandlers() {
        Handler<HttpClientResponse> handler = new Handler<HttpClientResponse>(){

            @Override
            public void handle(HttpClientResponse resp) {
                HttpResolution.this.handleRedirect(resp);
            }
        };
        this.addHandler(301, handler);
        this.addHandler(302, handler);
        this.addHandler(303, handler);
        this.addHandler(308, handler);
    }

    private static String getProxyHost() {
        return System.getProperty(HTTP_PROXY_HOST_PROP_NAME);
    }

    private String getBasicAuth() {
        String pass;
        if (this.repoUsername != null && this.repoPassword != null) {
            return this.autoInfo(this.repoUsername, this.repoPassword);
        }
        String user = System.getProperty(HTTP_BASIC_AUTH_USER_PROP_NAME);
        if (user != null && (pass = System.getProperty(HTTP_BASIC_AUTH_PASSWORD_PROP_NAME)) != null) {
            return this.autoInfo(user, pass);
        }
        return null;
    }

    private String autoInfo(String user, String pass) {
        return Base64.encodeBytes((user + ":" + pass).getBytes());
    }

    private static int getProxyPort() {
        return Integer.parseInt(System.getProperty(HTTP_PROXY_PORT_PROP_NAME, "80"));
    }
}

