/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.platform.impl.resolver;

import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.platform.impl.ModuleIdentifier;
import org.vertx.java.platform.impl.resolver.HttpResolution;

public class BintrayResolution
extends HttpResolution {
    private static final Logger log = LoggerFactory.getLogger(BintrayResolution.class);
    private final String uri;

    public BintrayResolution(Vertx vertx, String repoScheme, String repoHost, int repoPort, ModuleIdentifier moduleID, final String filename, String contentRoot) {
        super(vertx, repoScheme, null, null, repoHost, repoPort, moduleID, filename);
        this.addHandler(200, new Handler<HttpClientResponse>(){

            @Override
            public void handle(HttpClientResponse resp) {
                BintrayResolution.this.downloadToFile(filename, resp);
            }
        });
        this.addRedirectHandlers();
        String user = moduleID.getOwner();
        String repo = "vertx-mods";
        String modName = moduleID.getName();
        String version = moduleID.getVersion();
        StringBuilder sb = new StringBuilder(contentRoot);
        sb.append('/');
        sb.append(user).append('/').append(repo).append('/').append(modName).append('/').append(modName).append('-').append(version).append(".zip");
        this.uri = sb.toString();
    }

    @Override
    protected void getModule() {
        this.createClient(this.repoScheme, this.repoHost, this.repoPort);
        this.makeRequest(this.repoScheme, this.repoHost, this.repoPort, this.uri);
    }
}

