/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.utils;

import java.util.Properties;

public class NullArgumentException
extends IllegalArgumentException {
    private static final long serialVersionUID = 1L;
    private static final String IS_NULL = " is null.";
    private static final String IS_EMPTY = " is empty string.";

    public NullArgumentException(String msg) {
        super(msg);
    }

    public static void validateNotNull(Object obj, String objectName) throws NullArgumentException {
        if (obj == null) {
            throw new NullArgumentException(objectName + IS_NULL);
        }
    }

    public static void validateNotEmpty(String stringToCheck, String argumentName) throws NullArgumentException {
        NullArgumentException.validateNotEmpty(stringToCheck, false, argumentName);
    }

    public static void validateNotEmpty(String stringToCheck, boolean trim, String argumentName) throws NullArgumentException {
        NullArgumentException.validateNotNull(stringToCheck, argumentName);
        if (stringToCheck.length() == 0 || trim && stringToCheck.trim().length() == 0) {
            throw new NullArgumentException(argumentName + IS_EMPTY);
        }
    }

    public static void validateNotEmpty(Properties propertiesToCheck, String argumentName) throws NullArgumentException {
        NullArgumentException.validateNotNull(propertiesToCheck, argumentName);
        if (propertiesToCheck.isEmpty()) {
            throw new NullArgumentException(argumentName + IS_EMPTY);
        }
    }

    public static void validateNotEmpty(Object[] arrayToCheck, String argumentName) throws NullArgumentException {
        NullArgumentException.validateNotNull(arrayToCheck, argumentName);
        if (arrayToCheck.length == 0) {
            throw new NullArgumentException(argumentName + IS_EMPTY);
        }
    }

    public static void validateNotEmptyContent(String[] arrayToCheck, String argumentName) throws NullArgumentException {
        NullArgumentException.validateNotEmptyContent(arrayToCheck, false, argumentName);
    }

    public static void validateNotEmptyContent(String[] arrayToCheck, boolean trim, String argumentName) throws NullArgumentException {
        NullArgumentException.validateNotEmpty(arrayToCheck, argumentName);
        for (int i = 0; i < arrayToCheck.length; ++i) {
            NullArgumentException.validateNotEmpty(arrayToCheck[i], arrayToCheck[i] + "[" + i + "]");
            if (!trim) continue;
            NullArgumentException.validateNotEmpty(arrayToCheck[i].trim(), arrayToCheck[i] + "[" + i + "]");
        }
    }
}

