/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.container.process;

import com.google.common.collect.ImmutableMap;
import io.fabric8.agent.download.DownloadFuture;
import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.DownloadManagers;
import io.fabric8.agent.mvn.Parser;
import io.fabric8.agent.utils.AgentUtils;
import io.fabric8.api.Container;
import io.fabric8.api.CreateChildContainerMetadata;
import io.fabric8.api.CreateChildContainerOptions;
import io.fabric8.api.CreateContainerBasicOptions;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.CreationStateListener;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Profiles;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.support.Strings;
import io.fabric8.common.util.Files;
import io.fabric8.common.util.Objects;
import io.fabric8.container.process.JavaContainerConfig;
import io.fabric8.container.process.JolokiaAgentHelper;
import io.fabric8.container.process.ProcessContainerConfig;
import io.fabric8.container.process.ProcessControllerFactoryService;
import io.fabric8.container.process.ZooKeeperPublishConfig;
import io.fabric8.deployer.JavaContainers;
import io.fabric8.process.manager.DownloadStrategy;
import io.fabric8.process.manager.InstallContext;
import io.fabric8.process.manager.InstallOptions;
import io.fabric8.process.manager.InstallTask;
import io.fabric8.process.manager.Installation;
import io.fabric8.process.manager.ProcessController;
import io.fabric8.process.manager.ProcessManager;
import io.fabric8.process.manager.config.JsonHelper;
import io.fabric8.process.manager.config.ProcessConfig;
import io.fabric8.process.manager.support.ApplyConfigurationTask;
import io.fabric8.process.manager.support.CompositeTask;
import io.fabric8.process.manager.support.DownloadResourcesTask;
import io.fabric8.process.manager.support.InstallDeploymentsTask;
import io.fabric8.process.manager.support.JarInstaller;
import io.fabric8.process.manager.support.ProcessUtils;
import io.fabric8.service.child.ChildContainerController;
import io.fabric8.service.child.ChildContainers;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessManagerController
implements ChildContainerController {
    private static final transient Logger LOG = LoggerFactory.getLogger(ProcessManagerController.class);
    private final ProcessControllerFactoryService owner;
    private final Configurer configurer;
    private final ProcessManager processManager;
    private final FabricService fabricService;
    private final ExecutorService downloadExecutor = Executors.newSingleThreadExecutor();
    private final CuratorFramework curator;

    public ProcessManagerController(ProcessControllerFactoryService owner, Configurer configurer, ProcessManager processManager, FabricService fabricService, CuratorFramework curator) {
        this.owner = owner;
        this.configurer = configurer;
        this.processManager = processManager;
        this.fabricService = fabricService;
        this.curator = curator;
    }

    public CreateChildContainerMetadata create(CreateChildContainerOptions options, CreationStateListener listener) throws Exception {
        CreateChildContainerMetadata metadata = new CreateChildContainerMetadata();
        String containerId = options.getName();
        metadata.setCreateOptions((CreateContainerOptions)options);
        metadata.setContainerName(containerId);
        Container container = null;
        try {
            container = this.fabricService.getContainer(containerId);
        }
        catch (Exception e) {
            LOG.debug("Could nto find container: " + containerId);
        }
        if (container != null) {
            container.setProvisionResult("downloading");
        }
        ProcessManager procManager = this.processManager;
        HashMap<String, String> initialEnvironmentVariables = new HashMap<String, String>();
        Installation installation = this.createInstallation(procManager, container, options, metadata, initialEnvironmentVariables);
        if (container != null) {
            container.setProvisionResult("finalizing");
        }
        if (installation != null) {
            installation.getController().start();
        }
        return metadata;
    }

    public void start(Container container) {
        Installation installation = this.getInstallation(container);
        if (installation != null) {
            try {
                installation.getController().start();
            }
            catch (Exception e) {
                this.handleException("Starting container " + container.getId(), e);
            }
        }
    }

    public void stop(Container container) {
        Installation installation = this.getInstallation(container);
        if (installation != null) {
            try {
                installation.getController().stop();
                container.setProvisionResult("stopped");
                this.owner.deleteContainerZooKeeperPaths(installation, container);
            }
            catch (Exception e) {
                this.handleException("Stopping container " + container.getId(), e);
            }
        }
    }

    public void destroy(Container container) {
        Installation installation = this.getInstallation(container);
        if (installation != null) {
            try {
                installation.getController().stop();
                this.owner.deleteContainerZooKeeperPaths(installation, container);
            }
            catch (Exception e) {
                LOG.info("Failed to stop process for container " + container.getId() + ". " + e, (Throwable)e);
            }
            this.processManager.uninstall(installation);
        }
    }

    public void updateInstallation(final Container container, final Installation installation) throws Exception {
        CreateChildContainerOptions options;
        ProcessManager procManager;
        Installation newInstallation;
        CreateChildContainerMetadata metadata;
        CreateContainerOptions createOptions;
        Map<String, String> initialEnvironmentVariables = ProcessManagerController.getInstallationProxyPorts(installation);
        CreateContainerMetadata containerMetadata = container.getMetadata();
        if (!(containerMetadata instanceof CreateChildContainerMetadata) || !((createOptions = (metadata = (CreateChildContainerMetadata)containerMetadata).getCreateOptions()) instanceof CreateChildContainerOptions) || (newInstallation = this.createInstallation(procManager = new ProcessManager(){

            public Installation install(InstallOptions parameters, InstallTask postInstall) throws Exception {
                ProcessManagerController.this.updateInstallation(container, installation, parameters, postInstall);
                return null;
            }

            public Installation installJar(InstallOptions parameters, InstallTask postInstall) throws Exception {
                ProcessManagerController.this.updateInstallation(container, installation, parameters, null);
                return null;
            }

            public void uninstall(Installation installation2) {
                ProcessManagerController.this.processManager.uninstall(installation2);
            }

            public Executor getExecutor() {
                return ProcessManagerController.this.processManager.getExecutor();
            }

            public List<Installation> listInstallations() {
                return ProcessManagerController.this.processManager.listInstallations();
            }

            public ImmutableMap<String, Installation> listInstallationMap() {
                return ProcessManagerController.this.processManager.listInstallationMap();
            }

            public Installation getInstallation(String id) {
                return ProcessManagerController.this.processManager.getInstallation(id);
            }

            public ProcessConfig loadProcessConfig(InstallOptions options) throws IOException {
                return ProcessManagerController.this.processManager.loadProcessConfig(options);
            }
        }, container, options = (CreateChildContainerOptions)createOptions, metadata, initialEnvironmentVariables)) != null) {
            // empty if block
        }
    }

    public static Map<String, String> getInstallationProxyPorts(Installation installation) {
        HashMap<String, String> initialEnvironmentVariables = new HashMap<String, String>();
        ProcessConfig currentConfig = ProcessManagerController.getProcessConfig(installation);
        if (currentConfig != null) {
            Map environment = currentConfig.getEnvironment();
            for (Map.Entry entry : environment.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.endsWith("_PROXY_PORT")) continue;
                String value = (String)entry.getValue();
                initialEnvironmentVariables.put(key, value);
            }
        }
        return initialEnvironmentVariables;
    }

    protected void updateInstallation(Container container, Installation installation, InstallOptions parameters, InstallTask postInstall) throws Exception {
        boolean requiresRestart = false;
        ProcessConfig processConfig = this.processManager.loadProcessConfig(parameters);
        processConfig.setName(parameters.getName());
        ProcessConfig oldConfig = ProcessManagerController.getProcessConfig(installation);
        String id = installation.getId();
        File installDir = installation.getInstallDir();
        InstallContext installContext = new InstallContext(parameters.getContainer(), installDir, true);
        if (processConfig != null && !oldConfig.equals((Object)processConfig)) {
            installContext.addRestartReason("Environment Variables");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Requires restart as config has changed: OLD: " + JsonHelper.toJson((ProcessConfig)oldConfig) + " and NEW: " + JsonHelper.toJson((ProcessConfig)processConfig));
            }
        }
        if (postInstall != null) {
            postInstall.install(installContext, processConfig, id, installDir);
            JsonHelper.saveProcessConfig((ProcessConfig)processConfig, (File)installDir);
        } else {
            JarInstaller installer = new JarInstaller(parameters, this.processManager.getExecutor());
            installer.install(installContext, processConfig, id, installDir);
        }
        installContext.updateContainerChecksums();
        if (installContext.isRestartRequired()) {
            LOG.info("Restarting " + container.getId() + " due to profile changes: " + installContext.getRestartReasons());
            ProcessController controller = installation.getController();
            if (controller != null && container != null && container.isAlive()) {
                controller.restart();
            }
        }
    }

    protected static ProcessConfig getProcessConfig(Installation installation) {
        ProcessController controller = installation.getController();
        return controller.getConfig();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Installation createInstallation(ProcessManager procManager, Container container, CreateChildContainerOptions options, CreateChildContainerMetadata metadata, Map<String, String> initialEnvironmentVariables) throws Exception {
        String jolokiaUrl;
        String containerId = options.getName();
        Map environmentVariables = ChildContainers.getEnvironmentVariables((FabricService)this.fabricService, (CreateContainerBasicOptions)options);
        Set<Map.Entry<String, String>> initialEntries = initialEnvironmentVariables.entrySet();
        for (Map.Entry<String, String> entry : initialEntries) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (environmentVariables.containsKey(key)) continue;
            environmentVariables.put(key, value);
        }
        ProcessContainerConfig processConfig = this.createProcessContainerConfig(options, environmentVariables);
        if (container != null) {
            this.registerPorts(options, processConfig, container, environmentVariables);
        }
        JolokiaAgentHelper.substituteEnvironmentVariableExpressions(environmentVariables, environmentVariables, this.fabricService, this.curator, true);
        JolokiaAgentHelper.substituteEnvironmentVariableExpressions(environmentVariables, System.getenv(), null, null, true);
        this.publishZooKeeperValues(options, processConfig, container, environmentVariables);
        Installation installation = null;
        try {
            if (ChildContainers.isJavaContainer((FabricService)this.fabricService, (CreateContainerBasicOptions)options)) {
                LOG.debug("Java container detected - installing jar. Configuration: ", (Object)options);
                JavaContainerConfig javaConfig = this.createJavaContainerConfig(options);
                InstallOptions parameters = this.createJavaInstallOptions(container, metadata, options, javaConfig, environmentVariables);
                String layout = javaConfig.getOverlayFolder();
                InstallTask postInstall = this.createCommonPostInstal(options, environmentVariables, layout);
                Objects.notNull((Object)parameters, (String)"JavaInstall parameters");
                installation = procManager.installJar(parameters, postInstall);
            } else {
                LOG.debug("Process container detected - installing process. Configuration: ", (Object)options);
                InstallOptions parameters = this.createProcessInstallOptions(container, metadata, options, processConfig, environmentVariables);
                InstallTask postInstall = this.createProcessPostInstall(container, options, processConfig, environmentVariables);
                Objects.notNull((Object)parameters, (String)"process parameters");
                installation = procManager.install(parameters, postInstall);
            }
            if (container == null) {
                // empty if block
            }
        }
        catch (Exception e) {
            this.handleException("Creating container " + containerId, e);
        }
        LOG.info("Creating process container with environment vars: " + environmentVariables);
        String defaultHost = this.fabricService.getCurrentContainer().getLocalHostname();
        if (Strings.isNullOrBlank((String)defaultHost)) {
            defaultHost = "localhost";
        }
        if (!Strings.isNullOrBlank((String)(jolokiaUrl = JolokiaAgentHelper.findJolokiaUrlFromEnvironmentVariables(environmentVariables, defaultHost)))) {
            JavaContainers.registerJolokiaUrl((Container)container, (String)jolokiaUrl);
        }
        return installation;
    }

    protected InstallOptions createJavaInstallOptions(Container container, CreateChildContainerMetadata metadata, CreateChildContainerOptions options, JavaContainerConfig javaConfig, Map<String, String> environmentVariables) throws Exception {
        boolean isJavaContainer = true;
        javaConfig.updateEnvironmentVariables(environmentVariables, isJavaContainer);
        this.configureInstallOptionsJolokia(container.getId(), environmentVariables, javaConfig, isJavaContainer);
        Map<String, File> jarsFromProfiles = this.extractJarsFromProfiles(container, options);
        InstallOptions.InstallOptionsBuilder builder = InstallOptions.builder();
        if (javaConfig.getJarUrl() != null) {
            builder.url(javaConfig.getJarUrl());
        }
        builder.container(container);
        if (javaConfig.getJvmArguments() != null) {
            builder.jvmOptionsString(javaConfig.getJvmArguments());
        }
        builder.jarFiles(jarsFromProfiles);
        builder.id(options.getName());
        builder.environment(environmentVariables);
        String mainClass = environmentVariables.get("FABRIC8_JAVA_MAIN");
        String name = "java";
        if (!Strings.isNullOrBlank((String)mainClass)) {
            name = name + " " + mainClass;
        }
        builder.name(name);
        builder.downloadStrategy(this.createDownloadStrategy());
        metadata.setContainerType(name);
        builder.mainClass(mainClass);
        return builder.build();
    }

    protected DownloadStrategy createDownloadStrategy() throws MalformedURLException {
        Profile currentContainerOverlayProfile;
        Container container;
        if (this.fabricService != null && (container = this.fabricService.getCurrentContainer()) != null && (currentContainerOverlayProfile = this.fabricService.getCurrentContainer().getOverlayProfile()) != null) {
            final DownloadManager downloadManager = DownloadManagers.createDownloadManager((FabricService)this.fabricService, (ExecutorService)this.downloadExecutor);
            return new DownloadStrategy(){

                public File downloadContent(URL sourceUrl, File installDir) throws IOException {
                    DownloadFuture future = downloadManager.download(sourceUrl.toString());
                    File file = AgentUtils.waitForFileDownload((DownloadFuture)future);
                    if (file != null && file.exists() && file.isFile()) {
                        File newFile = new File(installDir, file.getName());
                        Files.copy((File)file, (File)newFile);
                        return newFile;
                    }
                    throw new IOException("Could not download " + sourceUrl);
                }
            };
        }
        return null;
    }

    protected JavaContainerConfig createJavaContainerConfig(CreateChildContainerOptions options) throws Exception {
        JavaContainerConfig javaConfig = new JavaContainerConfig();
        Map javaContainerConfig = Profiles.getOverlayConfiguration((FabricService)this.fabricService, (Iterable)options.getProfiles(), (String)options.getVersion(), (String)"io.fabric8.container.java");
        this.configurer.configure(javaContainerConfig, (Object)javaConfig, new String[0]);
        return javaConfig;
    }

    protected Map<String, File> extractJarsFromProfiles(Container container, CreateChildContainerOptions installOptions) throws Exception {
        List profiles = Profiles.getProfiles((FabricService)this.fabricService, (Iterable)installOptions.getProfiles(), (String)installOptions.getVersion());
        Map javaArtifacts = JavaContainers.getJavaContainerArtifactsFiles((FabricService)this.fabricService, (List)profiles, (ExecutorService)this.downloadExecutor);
        return javaArtifacts;
    }

    protected void configureInstallOptionsJolokia(String containerId, Map<String, String> environmentVariables, JavaContainerConfig javaConfig, boolean isJavaContainer) {
        if (JolokiaAgentHelper.hasJolokiaAgent(environmentVariables)) {
            String JOLOKIA_PROXY_PORT_ENV = "FABRIC8_JOLOKIA_PROXY_PORT";
            String portText = environmentVariables.get(JOLOKIA_PROXY_PORT_ENV);
            Integer portObject = null;
            if (portText != null) {
                try {
                    portObject = Integer.parseInt(portText);
                }
                catch (NumberFormatException e) {
                    LOG.warn("Ignoring bad port number for " + JOLOKIA_PROXY_PORT_ENV + " value '" + portText + ". " + e, (Throwable)e);
                }
            }
            int jolokiaPort = portObject != null ? portObject.intValue() : this.owner.createJolokiaPort(containerId);
            environmentVariables.put(JOLOKIA_PROXY_PORT_ENV, "" + jolokiaPort);
            JolokiaAgentHelper.substituteEnvironmentVariables(javaConfig, environmentVariables, isJavaContainer, JolokiaAgentHelper.getJolokiaPortOverride(jolokiaPort), JolokiaAgentHelper.getJolokiaAgentIdOverride(this.fabricService.getEnvironment()));
        } else {
            JolokiaAgentHelper.substituteEnvironmentVariables(javaConfig, environmentVariables, isJavaContainer, JolokiaAgentHelper.getJolokiaAgentIdOverride(this.fabricService.getEnvironment()));
        }
    }

    protected InstallOptions createProcessInstallOptions(Container container, CreateChildContainerMetadata metadata, CreateChildContainerOptions options, ProcessContainerConfig configObject, Map<String, String> environmentVariables) throws Exception {
        return configObject.createProcessInstallOptions(this.fabricService, container, metadata, options, environmentVariables, this.createDownloadStrategy());
    }

    private ProcessContainerConfig createProcessContainerConfig(CreateChildContainerOptions options, Map<String, String> environmentVariables) throws Exception {
        Set profileIds = options.getProfiles();
        String versionId = options.getVersion();
        Map configuration = Profiles.getOverlayConfiguration((FabricService)this.fabricService, (Iterable)profileIds, (String)versionId, (String)"io.fabric8.container.process");
        JolokiaAgentHelper.substituteEnvironmentVariableExpressions(configuration, environmentVariables, this.fabricService, this.curator, true);
        ProcessContainerConfig configObject = new ProcessContainerConfig();
        this.configurer.configure(configuration, (Object)configObject, new String[0]);
        return configObject;
    }

    protected InstallTask createProcessPostInstall(Container container, CreateChildContainerOptions options, ProcessContainerConfig configObject, Map<String, String> environmentVariables) throws Exception {
        Map javaArtifacts;
        Set profileIds = options.getProfiles();
        String versionId = options.getVersion();
        List profiles = Profiles.getProfiles((FabricService)this.fabricService, (Iterable)profileIds, (String)versionId);
        String layout = configObject.getOverlayFolder();
        InstallTask answer = this.createCommonPostInstal(options, environmentVariables, layout);
        if (!configObject.isInternalAgent() && !(javaArtifacts = JavaContainers.getJavaContainerArtifactsFiles((FabricService)this.fabricService, (List)profiles, (ExecutorService)this.downloadExecutor)).isEmpty()) {
            Map contextPathConfiguration = Profiles.getOverlayConfiguration((FabricService)this.fabricService, (Iterable)profileIds, (String)versionId, (String)"io.fabric8.web.contextPath");
            HashMap<String, String> locationToContextPathMap = new HashMap<String, String>();
            Set locations = javaArtifacts.keySet();
            for (String location : locations) {
                String key;
                String value;
                Parser parser = null;
                try {
                    parser = Parser.parsePathWithSchemePrefix((String)location);
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
                if (parser == null || (value = (String)contextPathConfiguration.get(key = parser.getGroup() + "/" + parser.getArtifact())) == null) continue;
                locationToContextPathMap.put(location, value);
            }
            Set contextPathEntries = contextPathConfiguration.entrySet();
            for (Map.Entry contextPathEntry : contextPathEntries) {
                String groupIdAndArtifactId = (String)contextPathEntry.getKey();
                String contextPath = (String)contextPathEntry.getValue();
                if (locationToContextPathMap.containsValue(contextPath)) continue;
                LOG.warn("Properties file io.fabric8.web.contextPath for profile(s) " + profileIds + " has unmatched contextPath mapping to " + contextPath + " for group id and artifact id key " + groupIdAndArtifactId + " when has matched values: " + locationToContextPathMap.values());
            }
            answer = CompositeTask.combine((InstallTask)answer, (InstallTask)new InstallDeploymentsTask(javaArtifacts, locationToContextPathMap));
            this.setProvisionList(container, javaArtifacts);
        }
        return answer;
    }

    protected InstallTask createCommonPostInstal(CreateChildContainerOptions options, Map<String, String> environmentVariables, String layout) {
        Map overlayResources;
        Map configuration;
        Set profileIds = options.getProfiles();
        String versionId = options.getVersion();
        List profiles = Profiles.getProfiles((FabricService)this.fabricService, (Iterable)profileIds, (String)versionId);
        InstallTask answer = null;
        if (layout != null && (configuration = ProcessUtils.getProcessLayout((List)profiles, (String)layout)) != null && !configuration.isEmpty()) {
            HashMap<String, String> variables = Profiles.getOverlayConfiguration((FabricService)this.fabricService, (Iterable)profileIds, (String)versionId, (String)"io.fabric8.template.variables");
            if (variables == null) {
                variables = new HashMap<String, String>();
            } else {
                JolokiaAgentHelper.substituteEnvironmentVariableExpressions(variables, environmentVariables, this.fabricService, this.curator, true);
            }
            variables.putAll(environmentVariables);
            LOG.info("Using template variables for MVEL: " + variables);
            answer = new ApplyConfigurationTask(configuration, variables);
        }
        if ((overlayResources = Profiles.getOverlayConfiguration((FabricService)this.fabricService, (Iterable)profileIds, (String)versionId, (String)"io.fabric8.container.process.overlay.resources")) != null && !overlayResources.isEmpty()) {
            answer = CompositeTask.combine(answer, (InstallTask)new DownloadResourcesTask(overlayResources));
        }
        return answer;
    }

    protected void setProvisionList(Container container, Map<String, File> javaArtifacts) {
        if (container != null) {
            ArrayList<String> provisionList = new ArrayList<String>();
            for (String name : javaArtifacts.keySet()) {
                int idx = name.indexOf(":mvn:");
                if (idx > 0) {
                    name = name.substring(idx + 1);
                }
                provisionList.add(name);
            }
            Collections.sort(provisionList);
            container.setProvisionList(provisionList);
        }
    }

    protected void registerPorts(CreateChildContainerOptions options, ProcessContainerConfig processConfig, Container container, Map<String, String> environmentVariables) {
        String containerId = options.getName();
        HashMap exposedPorts = new HashMap();
        HashMap<String, Integer> internalPorts = new HashMap<String, Integer>();
        HashMap<String, Integer> externalPorts = new HashMap<String, Integer>();
        Set usedPortByHost = this.fabricService.getPortService().findUsedPortByHost(this.fabricService.getCurrentContainer());
        HashMap emptyMap = new HashMap();
        Set profileIds = options.getProfiles();
        String versionId = options.getVersion();
        Map ports = Profiles.getOverlayConfiguration((FabricService)this.fabricService, (Iterable)profileIds, (String)versionId, (String)"io.fabric8.ports");
        TreeMap<Integer, String> sortedInternalPorts = new TreeMap<Integer, String>();
        for (Map.Entry portEntry : ports.entrySet()) {
            String portName = (String)portEntry.getKey();
            String portText = (String)portEntry.getValue();
            if (portText == null || io.fabric8.common.util.Strings.isNullOrBlank((String)portText)) continue;
            Integer port = null;
            try {
                port = Integer.parseInt(portText);
            }
            catch (NumberFormatException e) {
                LOG.warn("Ignoring bad port number for " + portName + " value '" + portText + "' in PID: " + "io.fabric8.ports");
            }
            if (port != null) {
                sortedInternalPorts.put(port, portName);
                internalPorts.put(portName, port);
                exposedPorts.put(portText + "/tcp", emptyMap);
                continue;
            }
            LOG.info("No port for " + portName);
        }
        String jolokiaUrl = null;
        Container currentContainer = this.fabricService.getCurrentContainer();
        String listenHost = currentContainer.getLocalIp();
        if (Strings.isNullOrBlank((String)listenHost)) {
            listenHost = currentContainer.getLocalHostname();
        }
        if (Strings.isNullOrBlank((String)listenHost)) {
            listenHost = "localhost";
        }
        if (!environmentVariables.containsKey("FABRIC8_LISTEN_ADDRESS")) {
            environmentVariables.put("FABRIC8_LISTEN_ADDRESS", listenHost);
        }
        HashSet<String> disableDynamicPorts = new HashSet<String>();
        String[] dynamicPortArray = processConfig.getDisableDynamicPorts();
        if (dynamicPortArray != null) {
            disableDynamicPorts.addAll(Arrays.asList(dynamicPortArray));
        }
        for (Map.Entry entry : sortedInternalPorts.entrySet()) {
            Integer port = (Integer)entry.getKey();
            String portName = (String)entry.getValue();
            int externalPort = port;
            environmentVariables.put("FABRIC8_" + portName + "_PORT", "" + port);
            String proxyPortEnvName = "FABRIC8_" + portName + "_PROXY_PORT";
            Integer currentProxyPort = null;
            String currentExternalPortText = environmentVariables.get(proxyPortEnvName);
            if (currentExternalPortText != null) {
                try {
                    currentProxyPort = Integer.parseInt(currentExternalPortText);
                }
                catch (NumberFormatException e) {
                    LOG.warn("Could not parse env var " + proxyPortEnvName + " of " + currentExternalPortText + " as a number: " + e, (Throwable)e);
                }
            }
            if (currentProxyPort != null) {
                externalPort = currentProxyPort;
            } else {
                if (!disableDynamicPorts.contains(portName)) {
                    externalPort = this.owner.createExternalPort(containerId, portName, usedPortByHost, (CreateContainerBasicOptions)options);
                }
                environmentVariables.put(proxyPortEnvName, "" + externalPort);
            }
            externalPorts.put(portName, externalPort);
            if (!portName.equals("JOLOKIA")) continue;
            jolokiaUrl = "http://" + listenHost + ":" + externalPort + "/jolokia/";
            LOG.info("Found Jolokia URL: " + jolokiaUrl);
        }
        if (processConfig.isCreateLocalContainerAddress()) {
            environmentVariables.put("FABRIC8_LOCAL_CONTAINER_ADDRESS", this.owner.createContainerLocalAddress(containerId, (CreateContainerBasicOptions)options));
        }
        if (jolokiaUrl != null) {
            JavaContainers.registerJolokiaUrl((Container)container, jolokiaUrl);
        }
    }

    protected void publishZooKeeperValues(CreateChildContainerOptions options, ProcessContainerConfig processConfig, Container container, Map<String, String> environmentVariables) {
        Map publishConfigurations = Profiles.getOverlayFactoryConfigurations((FabricService)this.fabricService, (Iterable)options.getProfiles(), (String)options.getVersion(), (String)"io.fabric8.zookeeper.publish");
        Set entries = publishConfigurations.entrySet();
        for (Map.Entry entry : entries) {
            String configName = (String)entry.getKey();
            Map exportConfig = (Map)entry.getValue();
            if (exportConfig == null || exportConfig.isEmpty()) continue;
            JolokiaAgentHelper.substituteEnvironmentVariableExpressions(exportConfig, environmentVariables, this.fabricService, this.curator, true);
            ZooKeeperPublishConfig config = new ZooKeeperPublishConfig();
            try {
                this.configurer.configure(exportConfig, (Object)config, new String[0]);
                config.publish(this.curator, options, processConfig, container, environmentVariables);
            }
            catch (Exception e) {
                LOG.warn("Failed to publish configuration " + configName + " of " + config + " due to: " + e, (Throwable)e);
            }
        }
    }

    protected Installation getInstallation(Container container) {
        return this.processManager.getInstallation(container.getId());
    }

    protected void handleException(String message, Exception cause) {
        throw new RuntimeException(message + ". " + cause, cause);
    }
}

