/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.container.process;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.common.util.Objects;
import io.fabric8.common.util.Strings;
import io.fabric8.container.process.JavaContainerConfig;
import io.fabric8.deployer.JavaContainers;
import io.fabric8.groovy.GroovyPlaceholderResolver;
import io.fabric8.internal.JsonHelper;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.InterpolationHelper;
import io.fabric8.zookeeper.utils.ZooKeeperMasterCache;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JolokiaAgentHelper {
    public static final int DEFAULT_JOLOKIA_PORT = 8778;
    public static final String JOLOKIA_PORTS_PID = "io.fabric8.jolokia";
    public static final String JOLOKIA_PORT_NAME = "JOLOKIA";
    private static final transient Logger LOG = LoggerFactory.getLogger(JolokiaAgentHelper.class);
    private static ObjectMapper jolokiaMapper = new ObjectMapper();

    public static String findJolokiaUrlFromEnvironmentVariables(Map<String, String> environmentVariables, String defaultHost) {
        String javaAgent = JolokiaAgentHelper.getJavaAgent(environmentVariables);
        String answer = JolokiaAgentHelper.findJolokiaUrlFromJavaAgent(javaAgent, defaultHost);
        if (Strings.isNullOrBlank((String)answer)) {
            answer = environmentVariables.get("FABRIC8_JOLOKIA_URL");
        }
        return answer;
    }

    public static String getJavaAgent(Map<String, String> environmentVariables) {
        return environmentVariables.get("FABRIC8_JAVA_AGENT");
    }

    public static boolean hasJolokiaAgent(String javaAgent) {
        return Strings.isNotBlank((String)javaAgent) && javaAgent.contains("jolokia");
    }

    public static boolean hasJolokiaAgent(Map<String, String> environmentVariables) {
        String javaAgent = JolokiaAgentHelper.getJavaAgent(environmentVariables);
        return JolokiaAgentHelper.hasJolokiaAgent(javaAgent);
    }

    public static String findJolokiaUrlFromJavaAgent(String javaAgent, String defaultHost) {
        if (JolokiaAgentHelper.hasJolokiaAgent(javaAgent)) {
            String[] valueExpressions;
            Properties properties = new Properties();
            String propertyText = javaAgent.trim();
            while (propertyText.endsWith("\"") || propertyText.endsWith("'")) {
                propertyText = propertyText.substring(0, propertyText.length() - 1);
            }
            int start = javaAgent.indexOf(61);
            if (start >= 0 && (valueExpressions = (propertyText = propertyText.substring(start + 1)).split(",")) != null) {
                for (String expression : valueExpressions) {
                    String[] keyValue = expression.split("=");
                    if (keyValue == null || keyValue.length <= 1) continue;
                    properties.put(keyValue[0], keyValue[1]);
                }
            }
            String port = properties.getProperty("port", "8778");
            String host = properties.getProperty("host", "0.0.0.0");
            if (host.equals("0.0.0.0")) {
                host = defaultHost;
            }
            return "http://" + host + ":" + port + "/jolokia/";
        }
        return null;
    }

    public static EnvironmentVariableOverride getJolokiaPortOverride(final int jolokiaPort) {
        return new EnvironmentVariableOverride(){

            @Override
            public String getKey() {
                return "FABRIC8_JOLOKIA_PROXY_PORT";
            }

            @Override
            public String getValue(String originalValue) {
                return "" + jolokiaPort;
            }
        };
    }

    public static EnvironmentVariableOverride getJolokiaAgentIdOverride(final String prefix) {
        return new EnvironmentVariableOverride(){

            @Override
            public String getKey() {
                return "FABRIC8_KARAF_NAME";
            }

            @Override
            public String getValue(String originalValue) {
                if (Strings.isNullOrBlank((String)prefix)) {
                    return originalValue;
                }
                return prefix + "--" + originalValue;
            }
        };
    }

    public static void substituteEnvironmentVariables(JavaContainerConfig javaConfig, Map<String, String> environmentVariables, boolean isJavaContainer, EnvironmentVariableOverride ... overrides) {
        UpdateAction action = JolokiaAgentHelper.substituteEnvironmentVariablesOnly(environmentVariables, overrides);
        JolokiaAgentHelper.updateJavaAgent(javaConfig, environmentVariables, isJavaContainer, action);
        JolokiaAgentHelper.updateArguments(javaConfig, environmentVariables, isJavaContainer, action);
        JolokiaAgentHelper.updateJvmArguments(javaConfig, environmentVariables, isJavaContainer, action);
    }

    public static UpdateAction substituteEnvironmentVariablesOnly(final Map<String, String> environmentVariables, EnvironmentVariableOverride ... overrides) {
        final Map<String, EnvironmentVariableOverride> overridesMap = JolokiaAgentHelper.getStringEnvironmentVariableOverrideMap(overrides);
        final HashMap used = new HashMap();
        return new UpdateAction(){

            @Override
            public String go(String string) {
                String answer = string;
                for (String key : environmentVariables.keySet()) {
                    String value = (String)environmentVariables.get(key);
                    if (overridesMap.containsKey(key)) {
                        EnvironmentVariableOverride override = (EnvironmentVariableOverride)overridesMap.remove(key);
                        value = override.getValue(value);
                        used.put(key, override);
                    }
                    answer = answer.replace("${env:" + key + "}", value);
                }
                for (String key : overridesMap.keySet()) {
                    answer = answer.replace("${env:" + key + "}", ((EnvironmentVariableOverride)overridesMap.get(key)).getValue(null));
                }
                for (String key : used.keySet()) {
                    overridesMap.put(key, used.get(key));
                }
                return answer;
            }
        };
    }

    public static void substituteEnvironmentVariableExpressions(Map<String, String> map, Map<String, String> environmentVariables, FabricService fabricService, final CuratorFramework curator, boolean preserveUnresolved) {
        String zkUser = null;
        String zkPassword = null;
        if (fabricService != null) {
            zkUser = fabricService.getZooKeeperUser();
            zkPassword = fabricService.getZookeeperPassword();
        }
        Set<Map.Entry<String, String>> envEntries = environmentVariables.entrySet();
        for (String key : map.keySet()) {
            String text;
            String oldText = text = map.get(key);
            if (!Strings.isNotBlank((String)text)) continue;
            for (Map.Entry<String, String> envEntry : envEntries) {
                String envKey = envEntry.getKey();
                String envValue = envEntry.getValue();
                if (!Strings.isNotBlank((String)envKey) || !Strings.isNotBlank((String)envValue)) continue;
                text = text.replace("${env:" + envKey + "}", envValue);
            }
            if (Strings.isNotBlank((String)zkUser)) {
                text = text.replace("${zookeeper.user}", zkUser);
            }
            if (Strings.isNotBlank((String)zkPassword)) {
                text = text.replace("${zookeeper.password}", zkPassword);
            }
            if (curator != null) {
                InterpolationHelper.SubstitutionCallback substitutionCallback = new InterpolationHelper.SubstitutionCallback(){

                    public String getValue(String key) {
                        if (key.startsWith("zk:")) {
                            try {
                                return new String(ZkPath.loadURL((CuratorFramework)curator, (String)key), "UTF-8");
                            }
                            catch (Exception e) {
                            }
                        } else if (key.startsWith("groovy:")) {
                            try {
                                return GroovyPlaceholderResolver.resolveValue((CuratorFramework)curator, (String)key);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return null;
                    }
                };
                text = preserveUnresolved ? InterpolationHelper.substVarsPreserveUnresolved((String)text, (String)"dummy", null, (Map)Collections.EMPTY_MAP, (InterpolationHelper.SubstitutionCallback)substitutionCallback) : InterpolationHelper.substVars((String)text, (String)"dummy", null, (Map)Collections.EMPTY_MAP, (InterpolationHelper.SubstitutionCallback)substitutionCallback);
            }
            if (Objects.equal((Object)oldText, (Object)text)) continue;
            map.put(key, text);
        }
    }

    public static void substituteEnvironmentVariableExpressions(Map<String, String> map, Map<String, String> environmentVariables, FabricService fabricService, CuratorFramework curator) {
        JolokiaAgentHelper.substituteEnvironmentVariableExpressions(map, environmentVariables, fabricService, curator, false);
    }

    public static Map<String, String> substituteEnvironmentVariableExpressionKeysAndValues(Map<String, String> map, Map<String, String> environmentVariables) {
        HashMap<String, String> answer = new HashMap<String, String>();
        Set<Map.Entry<String, String>> envEntries = environmentVariables.entrySet();
        for (String key : map.keySet()) {
            String text = key;
            if (!Strings.isNotBlank((String)text)) continue;
            for (Map.Entry<String, String> envEntry : envEntries) {
                String envKey = envEntry.getKey();
                String envValue = envEntry.getValue();
                if (!Strings.isNotBlank((String)envKey) || !Strings.isNotBlank((String)envValue)) continue;
                text = text.replace("${env:" + envKey + "}", envValue);
            }
            answer.put(text, map.get(key));
        }
        JolokiaAgentHelper.substituteEnvironmentVariableExpressions(answer, environmentVariables, null, null);
        return answer;
    }

    private static Map<String, EnvironmentVariableOverride> getStringEnvironmentVariableOverrideMap(EnvironmentVariableOverride ... overrides) {
        HashMap<String, EnvironmentVariableOverride> overridesMap = new HashMap<String, EnvironmentVariableOverride>();
        for (EnvironmentVariableOverride override : overrides) {
            overridesMap.put(override.getKey(), override);
        }
        return overridesMap;
    }

    private static void updateArguments(JavaContainerConfig javaConfig, Map<String, String> environmentVariables, boolean isJavaContainer, UpdateAction action) {
        String arguments = javaConfig.getArguments();
        if (Strings.isNotBlank((String)arguments)) {
            arguments = action.go(arguments);
        }
        javaConfig.setArguments(arguments);
        javaConfig.updateEnvironmentVariables(environmentVariables, isJavaContainer);
    }

    private static void updateJvmArguments(JavaContainerConfig javaConfig, Map<String, String> environmentVariables, boolean isJavaContainer, UpdateAction action) {
        String jvmArguments = javaConfig.getJvmArguments();
        if (Strings.isNotBlank((String)jvmArguments)) {
            jvmArguments = action.go(jvmArguments);
        }
        javaConfig.setJvmArguments(jvmArguments);
        javaConfig.updateEnvironmentVariables(environmentVariables, isJavaContainer);
    }

    private static void updateJavaAgent(JavaContainerConfig javaConfig, Map<String, String> environmentVariables, boolean isJavaContainer, UpdateAction action) {
        String javaAgent = javaConfig.getJavaAgent();
        if (Strings.isNotBlank((String)javaAgent)) {
            javaAgent = action.go(javaAgent);
        }
        javaConfig.setJavaAgent(javaAgent);
        javaConfig.updateEnvironmentVariables(environmentVariables, isJavaContainer);
    }

    public static void jolokiaKeepAliveCheck(ZooKeeperMasterCache zkMasterCache, FabricService fabric, String jolokiaUrl, String containerName) {
        Container container = null;
        try {
            container = fabric.getContainer(containerName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (container != null) {
            if (!Objects.equal((Object)jolokiaUrl, (Object)container.getJolokiaUrl())) {
                container.setJolokiaUrl(jolokiaUrl);
            }
            JolokiaAgentHelper.jolokiaKeepAliveCheck(zkMasterCache, fabric, container, null);
        }
    }

    public static List<String> jolokiaKeepAliveCheck(ZooKeeperMasterCache zkMasterCache, FabricService fabric, Container container, Map<String, String> envVars) {
        ArrayList<String> newZkContainerPaths = new ArrayList<String>();
        String jolokiaUrl = container.getJolokiaUrl();
        if (Strings.isNullOrBlank((String)jolokiaUrl)) {
            return newZkContainerPaths;
        }
        String containerName = container.getId();
        boolean debugLog = LOG.isDebugEnabled();
        if (debugLog) {
            LOG.debug("Performing keep alive jolokia check on " + containerName + " URL: " + jolokiaUrl);
        }
        String user = fabric.getZooKeeperUser();
        String password = fabric.getZookeeperPassword();
        String url = jolokiaUrl;
        int idx = jolokiaUrl.indexOf("://");
        if (idx > 0) {
            url = "http://" + user + ":" + password + "@" + jolokiaUrl.substring(idx + 3);
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        String listUrl = url + "list/?maxDepth=1";
        ArrayList<String> jmxDomains = new ArrayList<String>();
        boolean valid = false;
        try {
            JsonNode value;
            URL theUrl = new URL(listUrl);
            JsonNode jsonNode = jolokiaMapper.readTree(theUrl);
            if (jsonNode != null && (value = jsonNode.get("value")) != null) {
                Iterator iter = value.fieldNames();
                while (iter.hasNext()) {
                    jmxDomains.add((String)iter.next());
                }
                if (debugLog) {
                    LOG.debug("Container " + containerName + " has JMX Domains: " + jmxDomains);
                }
                valid = jmxDomains.size() > 0;
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to query: " + listUrl + ". " + e, (Throwable)e);
        }
        String provisionResult = container.getProvisionResult();
        if (debugLog) {
            LOG.debug("Current provision result: " + provisionResult + " valid: " + valid);
        }
        boolean bl = valid = valid && JolokiaAgentHelper.performExtraJolokiaChecks(zkMasterCache, fabric, container, jmxDomains, url, envVars, newZkContainerPaths);
        if (valid) {
            if (!Objects.equal((Object)"success", (Object)provisionResult) || !container.isAlive()) {
                container.setProvisionResult("success");
                container.setProvisionException(null);
                container.setAlive(true);
                JavaContainers.registerJolokiaUrl((Container)container, (String)jolokiaUrl);
            }
            if (!Objects.equal(jmxDomains, (Object)container.getJmxDomains())) {
                container.setJmxDomains(jmxDomains);
            }
        } else {
            if (container.isAlive()) {
                container.setAlive(true);
            }
            if (!Objects.equal((Object)"failed", (Object)provisionResult)) {
                container.setProvisionResult("failed");
            }
        }
        return newZkContainerPaths;
    }

    protected static boolean performExtraJolokiaChecks(ZooKeeperMasterCache zkMasterCache, FabricService fabric, Container container, List<String> jmxDomains, String url, Map<String, String> envVars, List<String> newZkContainerPaths) {
        if (zkMasterCache != null) {
            for (String jmxDomain : jmxDomains) {
                String json;
                String tomcatUrl;
                JsonNode jsonNode;
                if (!jmxDomain.startsWith("Catalina") && !jmxDomain.startsWith("Tomcat") || (jsonNode = JolokiaAgentHelper.postJson(tomcatUrl = url + "?maxDepth=6&maxCollectionSize=500&ignoreErrors=true&canonicalNaming=false", json = "{\"type\":\"read\",\"mbean\":\"*:j2eeType=WebModule,*\",\"attribute\":[\"displayName\",\"path\",\"stateName\",\"startTime\"]}")) == null) continue;
                List values = jsonNode.findValues("value");
                for (JsonNode value : values) {
                    Iterator fields = value.fields();
                    while (fields.hasNext()) {
                        String path;
                        Map.Entry next = (Map.Entry)fields.next();
                        JsonNode node = (JsonNode)next.getValue();
                        Object startTime = JolokiaAgentHelper.getValue(node, "startTime");
                        Object stateName = JolokiaAgentHelper.getValue(node, "stateName");
                        Object pathObject = JolokiaAgentHelper.getValue(node, "path");
                        String string = path = pathObject != null ? pathObject.toString() : "/";
                        if (path.length() == 0) {
                            path = "/";
                        }
                        Object displayName = JolokiaAgentHelper.getValue(node, "displayName");
                        JolokiaAgentHelper.updateZookeeperEntry(zkMasterCache, fabric, container, envVars, path, stateName, startTime, displayName, newZkContainerPaths);
                    }
                }
            }
        }
        return true;
    }

    protected static void updateZookeeperEntry(ZooKeeperMasterCache zkMasterCache, FabricService fabric, Container container, Map<String, String> envVars, String path, Object stateName, Object startTime, Object displayName, List<String> newZkContainerPaths) {
        String matchedZkPath = null;
        Map configuration = container.getOverlayProfile().getConfiguration("io.fabric8.web.contextPath");
        if (configuration != null) {
            for (Map.Entry entry : configuration.entrySet()) {
                if (!((String)entry.getValue()).equals(path)) continue;
                matchedZkPath = (String)entry.getKey();
                break;
            }
        }
        if (matchedZkPath != null) {
            String zkPath = ZkPath.WEBAPPS_CLUSTER.getPath(new String[]{matchedZkPath});
            if (JolokiaAgentHelper.isWebAppActive(stateName)) {
                String id = container.getId();
                String httpUrl = container.getHttpUrl();
                if (Strings.isNullOrBlank((String)httpUrl)) {
                    String ip;
                    String portText;
                    if (envVars != null && Strings.isNotBlank((String)(portText = envVars.get("FABRIC8_HTTP_PROXY_PORT"))) && Strings.isNotBlank((String)(ip = container.getIp()))) {
                        httpUrl = "http://" + ip + ":" + portText;
                    }
                    if (httpUrl == null) {
                        httpUrl = "";
                    }
                }
                String url = httpUrl + path;
                String json = "{\"id\":" + JsonHelper.jsonEncodeString((String)id) + ", \"container\":" + JsonHelper.jsonEncodeString((String)id) + ", \"services\":[" + JsonHelper.jsonEncodeString((String)url) + "]" + "}";
                try {
                    zkMasterCache.setStringData(zkPath, json, CreateMode.EPHEMERAL);
                    newZkContainerPaths.add(zkPath);
                }
                catch (Exception e) {
                    LOG.warn("Failed to register web app json at path " + path + " json: " + json + ". " + e, (Throwable)e);
                }
            } else {
                try {
                    zkMasterCache.deleteData(zkPath);
                }
                catch (Exception e) {
                    LOG.warn("Failed to remove web app json at path " + path + ". " + e, (Throwable)e);
                }
            }
        }
    }

    protected static boolean isWebAppActive(Object stateName) {
        if (stateName != null) {
            String text = stateName.toString().toLowerCase();
            return text.contains("start");
        }
        return false;
    }

    protected static Object getValue(JsonNode node, String key) {
        JsonNode jsonNode = node.get(key);
        if (jsonNode != null) {
            if (jsonNode.isTextual()) {
                return jsonNode.textValue();
            }
            if (jsonNode.isLong()) {
                return jsonNode.asLong();
            }
        }
        return null;
    }

    protected static JsonNode postJson(String url, String json) {
        block3: {
            try {
                URL theUrl = new URL(url);
                URLConnection connection = theUrl.openConnection();
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setConnectTimeout(50000);
                connection.setReadTimeout(5000);
                connection.connect();
                OutputStream os = connection.getOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter(os);
                writer.write(json);
                writer.close();
                if (!(connection instanceof HttpURLConnection)) break block3;
                int code = ((HttpURLConnection)connection).getResponseCode();
                if (code < 200 || code >= 300) {
                    LOG.warn("Got a " + code + " when posting to URL " + url + " with JSON: " + json);
                    break block3;
                }
                return jolokiaMapper.readTree(connection.getInputStream());
            }
            catch (IOException e) {
                LOG.warn("Failed ot post to " + url + " with JSON: " + json + ". " + e, (Throwable)e);
            }
        }
        return null;
    }

    public static interface UpdateAction {
        public String go(String var1);
    }

    public static interface EnvironmentVariableOverride {
        public String getKey();

        public String getValue(String var1);
    }
}

