/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.commands;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IOpenShiftConnection;
import io.fabric8.openshift.commands.OpenshiftCommandSupport;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;

@Command(name="application-destroy", scope="openshift", description="Destroys the target application")
public class ApplicationDestroyCommand
extends OpenshiftCommandSupport {
    static final String FORMAT = "%-30s %s";
    @Option(name="--domain", required=false, description="Use only applications of that domain.")
    String domainId;
    @Argument(index=0, name="application", required=true, description="The target application.")
    String applicationName;

    protected Object doExecute() throws Exception {
        IOpenShiftConnection connection = this.getOrCreateConnection();
        for (IDomain domain : connection.getDomains()) {
            if (this.domainId != null && !this.domainId.equals(domain.getId())) continue;
            IApplication application = domain.getApplicationByName(this.applicationName);
            application.destroy();
        }
        return null;
    }
}

