/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift;

import com.openshift.client.ApplicationScale;
import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IGearProfile;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.IUser;
import com.openshift.client.OpenShiftTimeoutException;
import com.openshift.client.cartridge.EmbeddableCartridge;
import com.openshift.client.cartridge.IEmbeddableCartridge;
import com.openshift.client.cartridge.IStandaloneCartridge;
import com.openshift.client.cartridge.StandaloneCartridge;
import com.openshift.internal.client.GearProfile;
import io.fabric8.api.Container;
import io.fabric8.api.ContainerAutoScaler;
import io.fabric8.api.ContainerAutoScalerFactory;
import io.fabric8.api.ContainerProvider;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.CreationStateListener;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricService;
import io.fabric8.api.NameValidator;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.openshift.CreateOpenshiftContainerMetadata;
import io.fabric8.openshift.CreateOpenshiftContainerOptions;
import io.fabric8.openshift.OpenShiftAutoScaler;
import io.fabric8.openshift.OpenShiftFacade;
import io.fabric8.openshift.OpenShiftUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.container.provider.openshift", configurationPid="io.fabric8.openshift", label="Fabric8 Openshift Container Provider", policy=ConfigurationPolicy.OPTIONAL, immediate=true, metatype=false)
@Service(value={ContainerProvider.class})
public final class OpenshiftContainerProvider
extends AbstractComponent
implements ContainerProvider<CreateOpenshiftContainerOptions, CreateOpenshiftContainerMetadata>,
ContainerAutoScalerFactory {
    public static final String PROPERTY_AUTOSCALE_SERVER_URL = "autoscale.server.url";
    public static final String PROPERTY_AUTOSCALE_LOGIN = "autoscale.login";
    public static final String PROPERTY_AUTOSCALE_PASSWORD = "autoscale.password";
    public static final String PROPERTY_AUTOSCALE_DOMAIN = "autoscale.domain";
    public static final String PREFIX_CARTRIDGE_ID = "id:";
    private static final transient Logger LOG = LoggerFactory.getLogger(OpenshiftContainerProvider.class);
    private static final String SCHEME = "openshift";
    @Reference
    private Configurer configurer;
    @Reference(referenceInterface=IOpenShiftConnection.class, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private final ValidatingReference<IOpenShiftConnection> openShiftConnection = new ValidatingReference();
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=MBeanServer.class)
    private MBeanServer mbeanServer;
    @Property(name="default.cartridge.url", label="Default Cartridge URL", value={"${default.cartridge.url}"})
    private String defaultCartridgeUrl;
    private ObjectName objectName;
    private OpenShiftFacade mbean;
    private final ValidatingReference<Map<String, ?>> configuration = new ValidatingReference();

    @Activate
    void activate(Map<String, ?> configuration) throws Exception {
        this.updateConfiguration(configuration);
        this.configurer.configure(configuration, (Object)this);
        this.activateComponent();
        if (this.mbeanServer != null) {
            this.objectName = new ObjectName("io.fabric8:type=OpenShift");
            this.mbean = new OpenShiftFacade(this);
            if (!this.mbeanServer.isRegistered(this.objectName)) {
                this.mbeanServer.registerMBean(this.mbean, this.objectName);
            }
        }
    }

    @Modified
    void modified(Map<String, ?> configuration) throws Exception {
        this.updateConfiguration(configuration);
        this.configurer.configure(configuration, (Object)this);
    }

    @Deactivate
    void deactivate() throws MBeanRegistrationException, InstanceNotFoundException {
        if (this.mbeanServer != null && this.mbeanServer.isRegistered(this.objectName)) {
            this.mbeanServer.unregisterMBean(this.objectName);
        }
        this.deactivateComponent();
    }

    private void updateConfiguration(Map<String, ?> configuration) {
        this.configuration.bind(Collections.unmodifiableMap(new HashMap(configuration)));
    }

    FabricService getFabricService() {
        return (FabricService)this.fabricService.get();
    }

    Map<String, ?> getConfiguration() {
        return (Map)this.configuration.get();
    }

    public CreateOpenshiftContainerOptions.Builder newBuilder() {
        return CreateOpenshiftContainerOptions.builder();
    }

    public CreateOpenshiftContainerMetadata create(CreateOpenshiftContainerOptions options, CreationStateListener listener) throws Exception {
        IApplication application;
        this.assertValid();
        IUser user = this.getOrCreateConnection(options).getUser();
        IDomain domain = OpenshiftContainerProvider.getOrCreateDomain(user, options);
        String cartridgeUrl = null;
        Set profiles = options.getProfiles();
        String versionId = options.getVersion();
        HashMap openshiftConfigOverlay = new HashMap();
        if (profiles != null && versionId != null) {
            Version version = ((FabricService)this.fabricService.get()).getVersion(versionId);
            if (version != null) {
                for (String profileId : profiles) {
                    Profile overlay;
                    Map openshiftConfig;
                    Profile profile = version.getProfile(profileId);
                    if (profile == null || (openshiftConfig = (overlay = profile.getOverlay()).getConfiguration("io.fabric8.openshift")) == null) continue;
                    openshiftConfigOverlay.putAll(openshiftConfig);
                }
            }
            cartridgeUrl = (String)openshiftConfigOverlay.get("cartridge");
        }
        if (cartridgeUrl == null) {
            cartridgeUrl = this.defaultCartridgeUrl;
        }
        String[] cartridgeUrls = cartridgeUrl.split(" ");
        LOG.info("Creating cartridges: " + cartridgeUrl);
        String standAloneCartridgeUrl = cartridgeUrls[0];
        StandaloneCartridge cartridge = standAloneCartridgeUrl.startsWith(PREFIX_CARTRIDGE_ID) ? new StandaloneCartridge(standAloneCartridgeUrl.substring(PREFIX_CARTRIDGE_ID.length())) : new StandaloneCartridge(new URL(standAloneCartridgeUrl));
        String zookeeperUrl = ((FabricService)this.fabricService.get()).getZookeeperUrl();
        String zookeeperPassword = ((FabricService)this.fabricService.get()).getZookeeperPassword();
        HashMap<String, String> userEnvVars = null;
        if (!options.isEnsembleServer()) {
            userEnvVars = new HashMap<String, String>();
            userEnvVars.put("OPENSHIFT_FUSE_ZOOKEEPER_URL", zookeeperUrl);
            userEnvVars.put("OPENSHIFT_FUSE_ZOOKEEPER_PASSWORD", zookeeperPassword);
            String zkPasswordEncode = System.getProperty("zookeeper.password.encode", "true");
            userEnvVars.put("OPENSHIFT_FUSE_ZOOKEEPER_PASSWORD_ENCODE", zkPasswordEncode);
        }
        String initGitUrl = null;
        int timeout = 0;
        ApplicationScale scale = null;
        String containerName = options.getName();
        long t0 = System.currentTimeMillis();
        try {
            application = domain.createApplication(containerName, (IStandaloneCartridge)cartridge, scale, (IGearProfile)new GearProfile(options.getGearProfile()), initGitUrl, timeout, userEnvVars, new IEmbeddableCartridge[0]);
        }
        catch (OpenShiftTimeoutException e) {
            long t1;
            do {
                Thread.sleep(5000L);
            } while ((application = domain.getApplicationByName(containerName)) == null && (t1 = System.currentTimeMillis()) - t0 < TimeUnit.MILLISECONDS.convert(15L, TimeUnit.MINUTES));
        }
        LOG.info("Created application " + containerName);
        ArrayList<IEmbeddableCartridge> list = new ArrayList<IEmbeddableCartridge>();
        int size = cartridgeUrls.length;
        for (int idx = 1; idx < size; ++idx) {
            String embeddedUrl = cartridgeUrls[idx];
            LOG.info("Adding embedded cartridge: " + embeddedUrl);
            if (embeddedUrl.startsWith(PREFIX_CARTRIDGE_ID)) {
                list.add(new EmbeddableCartridge(embeddedUrl.substring(PREFIX_CARTRIDGE_ID.length())));
                continue;
            }
            list.add(new EmbeddableCartridge(new URL(embeddedUrl)));
        }
        if (!list.isEmpty()) {
            application.addEmbeddableCartridges(list);
        }
        String gitUrl = application.getGitUrl();
        CreateOpenshiftContainerMetadata metadata = new CreateOpenshiftContainerMetadata(domain.getId(), application.getUUID(), application.getCreationLog(), gitUrl);
        metadata.setContainerName(containerName);
        metadata.setCreateOptions((CreateContainerOptions)options);
        return metadata;
    }

    public void start(Container container) {
        this.assertValid();
        this.getContainerApplication(container, true).start();
    }

    public void stop(Container container) {
        this.assertValid();
        this.getContainerApplication(container, true).stop();
    }

    public void destroy(Container container) {
        this.assertValid();
        IApplication app = this.getContainerApplication(container, false);
        if (app != null) {
            app.destroy();
        }
    }

    public String getScheme() {
        this.assertValid();
        return SCHEME;
    }

    public Class<CreateOpenshiftContainerOptions> getOptionsType() {
        this.assertValid();
        return CreateOpenshiftContainerOptions.class;
    }

    public Class<CreateOpenshiftContainerMetadata> getMetadataType() {
        this.assertValid();
        return CreateOpenshiftContainerMetadata.class;
    }

    public List<String> getDomains(String serverUrl, String login, String password) {
        List<IDomain> domains;
        ArrayList<String> answer = new ArrayList<String>();
        IOpenShiftConnection connection = OpenShiftUtils.createConnection(serverUrl, login, password);
        if (connection != null && (domains = connection.getDomains()) != null) {
            for (IDomain domain : domains) {
                answer.add(domain.getId());
            }
        }
        return answer;
    }

    public List<String> getGearProfiles(String serverUrl, String login, String password) {
        List<IDomain> domains;
        ArrayList<String> answer = new ArrayList<String>();
        IOpenShiftConnection connection = OpenShiftUtils.createConnection(serverUrl, login, password);
        if (connection != null && (domains = connection.getDomains()) != null) {
            for (IDomain domain : domains) {
                List<IGearProfile> gearProfiles = domain.getAvailableGearProfiles();
                for (IGearProfile gearProfile : gearProfiles) {
                    answer.add(gearProfile.getName());
                }
                if (answer.isEmpty()) continue;
                break;
            }
        }
        return answer;
    }

    private IApplication getContainerApplication(Container container, boolean required) {
        IApplication app = null;
        CreateOpenshiftContainerMetadata metadata = OpenShiftUtils.getContainerMetadata(container);
        if (metadata != null) {
            IOpenShiftConnection connection = this.getOrCreateConnection((CreateOpenshiftContainerOptions)metadata.getCreateOptions());
            app = OpenShiftUtils.getApplication(container, metadata, connection);
        }
        if (app == null && required) {
            throw new FabricException("Unable to find OpenShift application for " + container.getId());
        }
        return app;
    }

    private static IDomain getOrCreateDomain(IUser user, CreateOpenshiftContainerOptions options) {
        if (options.getDomain() == null || options.getDomain().isEmpty()) {
            return user.getDefaultDomain();
        }
        return OpenshiftContainerProvider.domainExists(user, options.getDomain()) ? user.getDomain(options.getDomain()) : user.createDomain(options.getDomain());
    }

    private static boolean domainExists(IUser user, String domainId) {
        for (IDomain domain : user.getDomains()) {
            if (!domainId.equals(domain.getId())) continue;
            return true;
        }
        return false;
    }

    private IOpenShiftConnection getOrCreateConnection(CreateOpenshiftContainerOptions options) {
        IOpenShiftConnection connection = (IOpenShiftConnection)this.openShiftConnection.getOptional();
        if (connection != null) {
            return connection;
        }
        return OpenShiftUtils.createConnection(options);
    }

    public ContainerAutoScaler createAutoScaler() {
        return new OpenShiftAutoScaler(this);
    }

    void bindOpenShiftConnection(IOpenShiftConnection service) {
        this.openShiftConnection.bind((Object)service);
    }

    void unbindOpenShiftConnection(IOpenShiftConnection service) {
        this.openShiftConnection.unbind((Object)service);
    }

    NameValidator createNameValidator(CreateOpenshiftContainerOptions options) {
        IUser user = this.getOrCreateConnection(options).getUser();
        final IDomain domain = OpenshiftContainerProvider.getOrCreateDomain(user, options);
        return new NameValidator(){

            public boolean isValid(String name) {
                IApplication application = domain.getApplicationByName(name);
                return application == null;
            }
        };
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }

    protected void bindMbeanServer(MBeanServer mBeanServer) {
        this.mbeanServer = mBeanServer;
    }

    protected void unbindMbeanServer(MBeanServer mBeanServer) {
        if (this.mbeanServer == mBeanServer) {
            this.mbeanServer = null;
        }
    }
}

