/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift;

import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.OpenShiftConnectionFactory;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.utils.Strings;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@Component(name="io.fabric8.openshift", description="Fabric Openshift Connection", policy=ConfigurationPolicy.REQUIRE, immediate=true, metatype=true)
public class ManagedOpenshiftConnection
extends AbstractComponent {
    private static final String SERVER_URL = "serverUrl";
    private static final String LOGIN = "login";
    private static final String PASSWORD = "password";
    private static final String FABRIC_CLIENT_ID = "fabric";
    private final OpenShiftConnectionFactory connectionFactory = new OpenShiftConnectionFactory();
    private ServiceRegistration<IOpenShiftConnection> registration;
    private IOpenShiftConnection connection;
    @Reference
    private Configurer configurer;
    @Property(name="serverUrl", label="Openshift Server URL", description="The URL to the Openshift server", value={"openshift.redhat.com"})
    String serverUrl;
    @Property(name="login", label="Login", description="The openshift account login")
    String login;
    @Property(name="password", label="Password", description="The openshift account password")
    String password;
    @Property(name="default.cartridge.url", label="Default Cartridge URL", value={"${default.cartridge.url}"})
    private String defaultCartridgeUrl;

    @Activate
    public void activate(BundleContext bundleContext, Map<String, String> properties) throws Exception {
        if (this.isConfigurationValid(properties)) {
            this.configurer.configure(properties, (Object)this);
            if (this.serverUrl != null && this.login != null && this.password != null) {
                this.connection = this.connectionFactory.getConnection(FABRIC_CLIENT_ID, this.login, this.password, this.serverUrl);
                this.registration = bundleContext.registerService(IOpenShiftConnection.class, (Object)this.connection, null);
            }
        }
    }

    @Deactivate
    public void deactivate() {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
    }

    private boolean isConfigurationValid(Map<String, String> properties) {
        return properties != null && properties.containsKey(SERVER_URL) && Strings.isNotBlank(properties.get(SERVER_URL)) && properties.containsKey(LOGIN) && Strings.isNotBlank(properties.get(LOGIN)) && properties.containsKey(PASSWORD) && Strings.isNotBlank(properties.get(PASSWORD));
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }
}

