/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands.support;

import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.karaf.shell.console.Completer;

public class ZNodeCompleter
implements Completer {
    private CuratorFramework curator;

    public void setCurator(CuratorFramework curator) {
        this.curator = curator;
    }

    public int complete(String buffer, int cursor, List candidates) {
        try {
            if (this.curator.getZookeeperClient().isConnected()) {
                if (buffer == null) {
                    candidates.add("/");
                    return 1;
                }
                if (!buffer.startsWith("/")) {
                    return 0;
                }
                String path = buffer = buffer.substring(0, cursor);
                int idx = path.lastIndexOf("/") + 1;
                String prefix = path.substring(idx);
                String dir = idx == 1 ? "/" : path.substring(0, idx - 1);
                List children = ZooKeeperUtils.getChildren((CuratorFramework)this.curator, (String)dir);
                for (String child : children) {
                    if (!child.startsWith(prefix)) continue;
                    candidates.add(child);
                }
                return candidates.size() == 0 ? buffer.length() : buffer.lastIndexOf("/") + 1;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return 0;
    }
}

