/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jaas;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.utils.properties.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperProperties
extends Properties {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperProperties.class);
    private final String path;
    private final CuratorFramework curator;

    public ZookeeperProperties(CuratorFramework curator, String path) throws Exception {
        this.path = path;
        this.curator = curator;
    }

    @Override
    public void save() throws IOException {
        if (this.curator == null) {
            throw new IOException("Curator not bound");
        }
        StringWriter writer = new StringWriter();
        this.saveLayout(writer);
        try {
            this.curator.setData().forPath(this.path, writer.toString().getBytes());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected void load() throws Exception {
        byte[] data = (byte[])this.curator.getData().forPath(this.path);
        String value = new String(data);
        if (value != null) {
            this.clear();
            this.load(new StringReader(value));
        }
    }
}

