/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.git.internal;

import io.fabric8.common.util.Strings;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.StoredConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHelpers {
    private static final transient Logger LOG = LoggerFactory.getLogger(GitHelpers.class);

    public static File getRootGitDirectory(Git git) {
        return git.getRepository().getDirectory().getParentFile();
    }

    public static boolean localBranchExists(Git git, String branch) throws GitAPIException {
        Object list = git.branchList().call();
        String fullName = "refs/heads/" + branch;
        boolean localBranchExists = false;
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            Ref ref = (Ref)i$.next();
            String name = ref.getName();
            if (!GitHelpers.equals(name, fullName)) continue;
            localBranchExists = true;
        }
        return localBranchExists;
    }

    public static String currentBranch(Git git) {
        String branch = null;
        Exception gitException = null;
        try {
            branch = git.getRepository().getBranch();
        }
        catch (Exception ex) {
            gitException = ex;
        }
        if (branch == null || gitException != null) {
            throw new IllegalStateException("Failed to get the current branch", gitException);
        }
        return branch;
    }

    public static boolean hasGitHead(Git git) throws GitAPIException, IOException {
        boolean hasHead = true;
        try {
            git.log().all().call();
            hasHead = git.getRepository().getAllRefs().containsKey("HEAD");
        }
        catch (NoHeadException e) {
            hasHead = false;
        }
        return hasHead;
    }

    public static void createOrCheckoutBranch(Git git, String branch, String remote) throws GitAPIException {
        Ref ref = null;
        String current = GitHelpers.currentBranch(git);
        if (!GitHelpers.equals(current, branch) && !GitHelpers.localBranchExists(git, branch)) {
            ref = git.checkout().setName(branch).setForce(true).setCreateBranch(true).call();
            GitHelpers.configureBranch(git, branch, remote);
        } else {
            ref = git.checkout().setName(branch).setForce(true).call();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checked out branch " + branch + " with results " + ref.getName());
        }
    }

    public static void checkoutBranch(Git git, String branch) throws GitAPIException {
        String current = GitHelpers.currentBranch(git);
        if (GitHelpers.equals(current, branch)) {
            return;
        }
        if (GitHelpers.localBranchExists(git, branch)) {
            Ref ref = git.checkout().setName(branch).setForce(true).call();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checked out branch " + branch + " with results " + ref.getName());
            }
        } else {
            LOG.debug("Branch " + branch + "not found!");
        }
    }

    public static void removeBranch(Git git, String branch) throws GitAPIException {
        if (GitHelpers.localBranchExists(git, branch)) {
            String current = GitHelpers.currentBranch(git);
            if (GitHelpers.equals(current, branch)) {
                GitHelpers.checkoutBranch(git, "master");
                return;
            }
            Object list = git.branchDelete().setBranchNames(branch).setForce(true).call();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleted branch " + branch + " with results " + list);
            }
        } else {
            LOG.debug("Branch " + branch + "not found!");
        }
    }

    protected static void configureBranch(Git git, String branch, String remote) {
        StoredConfig config;
        if (Strings.isNotBlank((String)branch) && (Strings.isNullOrBlank((String)(config = git.getRepository().getConfig()).getString("branch", branch, "remote")) || Strings.isNullOrBlank((String)config.getString("branch", branch, "merge")))) {
            config.setString("branch", branch, "remote", remote);
            config.setString("branch", branch, "merge", "refs/heads/" + branch);
            try {
                config.save();
            }
            catch (IOException e) {
                LOG.error("Failed to configure the branch configuration to " + GitHelpers.getRootGitDirectory(git) + " with branch " + branch + " on remote repo: " + remote + ". " + e, (Throwable)e);
            }
        }
    }

    static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }
}

