/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveCommand
extends GitCommand<OutputStream> {
    private static final ConcurrentMap<String, Format<?>> formats = new ConcurrentHashMap();
    private OutputStream out;
    private ObjectId tree;
    private String format;
    private String suffix;

    public static void registerFormat(String name, Format<?> fmt) {
        if (formats.putIfAbsent(name, fmt) != null) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().archiveFormatAlreadyRegistered, name));
        }
    }

    public static void unregisterFormat(String name) {
        if (formats.remove(name) == null) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().archiveFormatAlreadyAbsent, name));
        }
    }

    private static Format<?> formatBySuffix(String filenameSuffix) throws UnsupportedFormatException {
        if (filenameSuffix != null) {
            for (Format fmt : formats.values()) {
                for (String sfx : fmt.suffixes()) {
                    if (!filenameSuffix.endsWith(sfx)) continue;
                    return fmt;
                }
            }
        }
        return ArchiveCommand.lookupFormat("tar");
    }

    private static Format<?> lookupFormat(String formatName) throws UnsupportedFormatException {
        Format fmt = (Format)formats.get(formatName);
        if (fmt == null) {
            throw new UnsupportedFormatException(formatName);
        }
        return fmt;
    }

    public ArchiveCommand(Repository repo) {
        super(repo);
        this.setCallable(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Closeable> OutputStream writeArchive(Format<T> fmt) {
        TreeWalk walk = new TreeWalk(this.repo);
        try {
            T outa = fmt.createArchiveOutputStream(this.out);
            try {
                MutableObjectId idBuf = new MutableObjectId();
                ObjectReader reader = walk.getObjectReader();
                RevWalk rw = new RevWalk(walk.getObjectReader());
                walk.reset((AnyObjectId)rw.parseTree(this.tree));
                walk.setRecursive(true);
                while (walk.next()) {
                    String name = walk.getPathString();
                    FileMode mode = walk.getFileMode(0);
                    if (mode == FileMode.TREE) continue;
                    walk.getObjectId(idBuf, 0);
                    fmt.putEntry(outa, name, mode, reader.open(idBuf));
                }
            }
            finally {
                outa.close();
            }
            OutputStream outputStream = this.out;
            return outputStream;
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfArchiveCommand, e);
        }
        finally {
            walk.release();
        }
    }

    @Override
    public OutputStream call() throws GitAPIException {
        this.checkCallable();
        Format<?> fmt = this.format == null ? ArchiveCommand.formatBySuffix(this.suffix) : ArchiveCommand.lookupFormat(this.format);
        return this.writeArchive(fmt);
    }

    public ArchiveCommand setTree(ObjectId tree) {
        if (tree == null) {
            throw new IllegalArgumentException();
        }
        this.tree = tree;
        this.setCallable(true);
        return this;
    }

    public ArchiveCommand setFilename(String filename) {
        int slash = filename.lastIndexOf(47);
        int dot = filename.indexOf(46, slash + 1);
        this.suffix = dot == -1 ? "" : filename.substring(dot);
        return this;
    }

    public ArchiveCommand setOutputStream(OutputStream out) {
        this.out = out;
        return this;
    }

    public ArchiveCommand setFormat(String fmt) {
        this.format = fmt;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Format<T extends Closeable> {
        public T createArchiveOutputStream(OutputStream var1) throws IOException;

        public void putEntry(T var1, String var2, FileMode var3, ObjectLoader var4) throws IOException;

        public Iterable<String> suffixes();
    }

    public static class UnsupportedFormatException
    extends GitAPIException {
        private static final long serialVersionUID = 1L;
        private final String format;

        public UnsupportedFormatException(String format) {
            super(MessageFormat.format(JGitText.get().unsupportedArchiveFormat, format));
            this.format = format;
        }

        public String getFormat() {
            return this.format;
        }
    }
}

