/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.Transport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransportCommand<C extends GitCommand, T>
extends GitCommand<T> {
    protected CredentialsProvider credentialsProvider;
    protected int timeout;
    protected TransportConfigCallback transportConfigCallback;

    protected TransportCommand(Repository repo) {
        super(repo);
    }

    public C setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this.self();
    }

    public C setTimeout(int timeout) {
        this.timeout = timeout;
        return this.self();
    }

    public C setTransportConfigCallback(TransportConfigCallback transportConfigCallback) {
        this.transportConfigCallback = transportConfigCallback;
        return this.self();
    }

    protected final C self() {
        return (C)this;
    }

    protected C configure(Transport transport) {
        if (this.credentialsProvider != null) {
            transport.setCredentialsProvider(this.credentialsProvider);
        }
        transport.setTimeout(this.timeout);
        if (this.transportConfigCallback != null) {
            this.transportConfigCallback.configure(transport);
        }
        return this.self();
    }

    protected C configure(TransportCommand childCommand) {
        childCommand.setCredentialsProvider(this.credentialsProvider);
        childCommand.setTimeout(this.timeout);
        childCommand.setTransportConfigCallback(this.transportConfigCallback);
        return this.self();
    }
}

