/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.http.server.ServletUtils;
import org.eclipse.jgit.util.TemporaryBuffer;

class SmartOutputStream
extends TemporaryBuffer {
    private static final int LIMIT = 32768;
    private final HttpServletRequest req;
    private final HttpServletResponse rsp;
    private boolean compressStream;
    private boolean startedOutput;

    SmartOutputStream(HttpServletRequest req, HttpServletResponse rsp, boolean compressStream) {
        super(32768);
        this.req = req;
        this.rsp = rsp;
        this.compressStream = compressStream;
    }

    protected OutputStream overflow() throws IOException {
        this.startedOutput = true;
        Object out = this.rsp.getOutputStream();
        if (this.compressStream && ServletUtils.acceptsGzipEncoding(this.req)) {
            this.rsp.setHeader("Content-Encoding", "gzip");
            out = new GZIPOutputStream((OutputStream)out);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        super.close();
        if (!this.startedOutput) {
            SmartOutputStream out = this;
            if (256L < out.length() && ServletUtils.acceptsGzipEncoding(this.req)) {
                TemporaryBuffer.Heap gzbuf = new TemporaryBuffer.Heap(32768);
                try {
                    GZIPOutputStream gzip = new GZIPOutputStream((OutputStream)gzbuf);
                    try {
                        out.writeTo(gzip, null);
                    }
                    finally {
                        gzip.close();
                    }
                    if (gzbuf.length() < out.length()) {
                        out = gzbuf;
                        this.rsp.setHeader("Content-Encoding", "gzip");
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.rsp.setContentLength((int)out.length());
            ServletOutputStream os = this.rsp.getOutputStream();
            try {
                out.writeTo((OutputStream)os, null);
                os.flush();
            }
            finally {
                os.close();
            }
        }
    }
}

