/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class HostUtils {
    public static final String PREFERED_ADDRESS_PROPERTY_NAME = "preferred.network.address";

    private HostUtils() {
    }

    public static Map<String, Set<InetAddress>> getNetworkInterfaceAddresses() {
        TreeMap<String, Set<InetAddress>> interfaceAddressMap = new TreeMap<String, Set<InetAddress>>();
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                if (!iface.isUp() || iface.isLoopback()) continue;
                String name = iface.getName();
                Enumeration<InetAddress> ifaceAdresses = iface.getInetAddresses();
                while (ifaceAdresses.hasMoreElements()) {
                    InetAddress ia = ifaceAdresses.nextElement();
                    if (ia.isLoopbackAddress() || ia.getHostAddress().indexOf(":") != -1) continue;
                    LinkedHashSet<InetAddress> addresses = (LinkedHashSet<InetAddress>)interfaceAddressMap.get(name);
                    if (addresses == null) {
                        addresses = new LinkedHashSet<InetAddress>();
                    }
                    addresses.add(ia);
                    interfaceAddressMap.put(name, addresses);
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return interfaceAddressMap;
    }

    public static Set<InetAddress> getAddresses() {
        LinkedHashSet<InetAddress> allAddresses = new LinkedHashSet<InetAddress>();
        Map<String, Set<InetAddress>> interfaceAddressMap = HostUtils.getNetworkInterfaceAddresses();
        for (Map.Entry<String, Set<InetAddress>> entry : interfaceAddressMap.entrySet()) {
            Set<InetAddress> addresses = entry.getValue();
            if (addresses.isEmpty()) continue;
            for (InetAddress address : addresses) {
                allAddresses.add(address);
            }
        }
        return allAddresses;
    }

    private static InetAddress chooseAddress(String preferred) throws UnknownHostException {
        Set<InetAddress> addresses = HostUtils.getAddresses();
        if (preferred != null && !preferred.isEmpty()) {
            try {
                InetAddress preferredAddress = InetAddress.getByName(preferred);
                if (addresses != null && addresses.contains(preferredAddress)) {
                    return preferredAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (addresses.contains(InetAddress.getLocalHost())) {
            return InetAddress.getLocalHost();
        }
        if (addresses != null && !addresses.isEmpty()) {
            return addresses.toArray(new InetAddress[addresses.size()])[0];
        }
        return InetAddress.getLocalHost();
    }

    public static String getLocalHostName() throws UnknownHostException {
        String preffered = System.getProperty(PREFERED_ADDRESS_PROPERTY_NAME);
        return HostUtils.chooseAddress(preffered).getHostName();
    }

    public static String getLocalIp() throws UnknownHostException {
        String preffered = System.getProperty(PREFERED_ADDRESS_PROPERTY_NAME);
        return HostUtils.chooseAddress(preffered).getHostAddress();
    }
}

