/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.specimpl.PathSegmentImpl;

@Provider
@PreMatching
public class AcceptHeaderByFileSuffixFilter
implements ContainerRequestFilter {
    public Map<String, String> mediaTypeMappings = new HashMap<String, String>();
    public Map<String, String> languageMappings = new HashMap<String, String>();

    public void setMediaTypeMappings(Map<String, MediaType> mediaTypeMappings) {
        this.mediaTypeMappings.clear();
        for (Map.Entry<String, MediaType> entry : mediaTypeMappings.entrySet()) {
            this.mediaTypeMappings.put(entry.getKey(), entry.getValue().toString());
        }
    }

    public void setLanguageMappings(Map<String, String> languageMappings) {
        this.languageMappings.clear();
        for (Map.Entry<String, String> entry : languageMappings.entrySet()) {
            this.languageMappings.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {
        List<PathSegment> segments = null;
        if (this.mediaTypeMappings != null || this.languageMappings != null) {
            segments = this.process(requestContext, segments);
        }
        if (segments == null) {
            return;
        }
        StringBuilder preprocessedPath = new StringBuilder();
        for (PathSegment pathSegment : segments) {
            preprocessedPath.append("/").append(pathSegment.getPath());
        }
        if (!requestContext.getUriInfo().getQueryParameters().isEmpty()) {
            int sep = 63;
            for (Map.Entry entry : requestContext.getUriInfo().getQueryParameters(false).entrySet()) {
                for (String value : (List)entry.getValue()) {
                    preprocessedPath.append((char)sep);
                    sep = 38;
                    preprocessedPath.append((String)entry.getKey()).append('=').append(value);
                }
            }
        }
        URI requestUri = URI.create(preprocessedPath.toString());
        requestContext.setRequestUri(requestUri);
    }

    private List<PathSegment> process(ContainerRequestContext in, List<PathSegment> segments) {
        int index;
        String path = in.getUriInfo().getPath(false);
        int lastSegment = path.lastIndexOf(47);
        if (lastSegment < 0) {
            lastSegment = 0;
        }
        if ((index = path.indexOf(46, lastSegment)) < 0) {
            return null;
        }
        boolean preprocessed = false;
        String extension = path.substring(index + 1);
        String[] extensions = extension.split("\\.");
        StringBuilder rebuilt = new StringBuilder(path.substring(0, index));
        for (String ext : extensions) {
            String match;
            if (this.mediaTypeMappings != null && (match = this.mediaTypeMappings.get(ext)) != null) {
                in.getHeaders().addFirst("Accept", match);
                preprocessed = true;
                continue;
            }
            if (this.languageMappings != null && (match = this.languageMappings.get(ext)) != null) {
                in.getHeaders().add("Accept-Language", match);
                preprocessed = true;
                continue;
            }
            rebuilt.append(".").append(ext);
        }
        if (preprocessed) {
            segments = PathSegmentImpl.parseSegments(rebuilt.toString(), false);
        }
        return segments;
    }
}

