/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.child;

import io.fabric8.api.Container;
import io.fabric8.api.CreateContainerBasicOptions;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profiles;
import io.fabric8.common.util.Strings;
import io.fabric8.utils.PasswordEncoder;
import java.util.Map;
import java.util.Set;

public class ChildContainers {
    public static boolean isJavaOrProcessContainer(FabricService fabric, Container container) {
        CreateContainerOptions createOptions;
        CreateContainerMetadata metadata;
        if (container != null && (metadata = container.getMetadata()) != null && (createOptions = metadata.getCreateOptions()) instanceof CreateContainerBasicOptions) {
            return ChildContainers.isJavaOrProcessContainer(fabric, (CreateContainerBasicOptions)createOptions);
        }
        return false;
    }

    public static boolean isJavaOrProcessContainer(FabricService fabric, CreateContainerBasicOptions options) {
        boolean isJavaContainer = ChildContainers.isJavaContainer(fabric, options);
        boolean isProcessContainer = ChildContainers.isProcessContainer(fabric, options);
        return isProcessContainer || isJavaContainer;
    }

    public static boolean isJavaContainer(FabricService fabricService, CreateContainerBasicOptions options) {
        Map javaContainerConfig = Profiles.getOverlayConfiguration((FabricService)fabricService, (Iterable)options.getProfiles(), (String)options.getVersion(), (String)"io.fabric8.container.java");
        return !javaContainerConfig.isEmpty();
    }

    public static boolean isProcessContainer(FabricService fabricService, CreateContainerBasicOptions options) {
        String versionId;
        Set profileIds = options.getProfiles();
        Map processConfig = Profiles.getOverlayConfiguration((FabricService)fabricService, (Iterable)profileIds, (String)(versionId = options.getVersion()), (String)"io.fabric8.container.process");
        return processConfig != null && processConfig.size() > 0;
    }

    public static Map<String, String> getEnvironmentVariables(FabricService service, CreateContainerBasicOptions options) {
        String localIp;
        Set profileIds = options.getProfiles();
        String versionId = options.getVersion();
        String zookeeperUrl = service.getZookeeperUrl();
        String zookeeperUser = service.getZooKeeperUser();
        String zookeeperPasswordRaw = service.getZookeeperPassword();
        String zookeeperPassword = zookeeperPasswordRaw;
        if (zookeeperPassword != null) {
            zookeeperPassword = PasswordEncoder.encode(zookeeperPassword);
        }
        if (!Strings.isNullOrBlank((String)(localIp = service.getCurrentContainer().getLocalIp()))) {
            int idx = zookeeperUrl.lastIndexOf(58);
            if (idx > 0) {
                localIp = localIp + zookeeperUrl.substring(idx);
            }
            zookeeperUrl = localIp;
        }
        Map envVarsOverlay = Profiles.getOverlayConfiguration((FabricService)service, (Iterable)profileIds, (String)versionId, (String)"io.fabric8.environment");
        String containerName = options.getName();
        envVarsOverlay.put("FABRIC8_KARAF_NAME", containerName);
        envVarsOverlay.put("FABRIC8_RUNTIME_ID", containerName);
        if (!options.isEnsembleServer()) {
            if (!envVarsOverlay.containsKey("FABRIC8_ZOOKEEPER_URL")) {
                envVarsOverlay.put("FABRIC8_ZOOKEEPER_URL", zookeeperUrl);
            }
            if (!envVarsOverlay.containsKey("FABRIC8_ZOOKEEPER_USER")) {
                envVarsOverlay.put("FABRIC8_ZOOKEEPER_USER", zookeeperUser);
            }
            if (!envVarsOverlay.containsKey("FABRIC8_ZOOKEEPER_PASSWORD")) {
                envVarsOverlay.put("FABRIC8_ZOOKEEPER_PASSWORD", zookeeperPassword);
            }
            if (!envVarsOverlay.containsKey("FABRIC8_ZOOKEEPER_PASSWORD_RAW")) {
                envVarsOverlay.put("FABRIC8_ZOOKEEPER_PASSWORD_RAW", zookeeperPasswordRaw);
            }
            if (!envVarsOverlay.containsKey("FABRIC8_ZOOKEEPER_PASSWORD_ENCODE")) {
                String zkPasswordEncode = System.getProperty("zookeeper.password.encode", "true");
                envVarsOverlay.put("FABRIC8_ZOOKEEPER_PASSWORD_ENCODE", zkPasswordEncode);
            }
        }
        return envVarsOverlay;
    }
}

