/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.internal.autoscale;

import io.fabric8.api.Container;
import io.fabric8.api.HostConfiguration;
import io.fabric8.api.HostScalingRequirements;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.api.Profiles;
import io.fabric8.common.util.Filter;
import io.fabric8.common.util.Filters;
import io.fabric8.common.util.Objects;
import io.fabric8.internal.autoscale.HostProfileCounter;
import io.fabric8.internal.autoscale.LoadSortedHostConfiguration;
import io.fabric8.utils.CountingMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class AutoScalers {
    public static Filter<String> createHostAliasFilter(HostScalingRequirements scalingRequirements) {
        List hostPatterns;
        if (scalingRequirements != null && (hostPatterns = scalingRequirements.getHostPatterns()) != null && hostPatterns.size() > 0) {
            return Filters.createStringFilters((Iterable)hostPatterns);
        }
        return Filters.trueFilter();
    }

    public static Filter<HostConfiguration> createHostConfigFilter(HostScalingRequirements scalingRequirements) {
        List matchTags;
        if (scalingRequirements != null && (matchTags = scalingRequirements.getHostTags()) != null && matchTags.size() > 0) {
            return new Filter<HostConfiguration>(){

                public String toString() {
                    return "Filter(HostConfiguration has tags: " + matchTags + ")";
                }

                public boolean matches(HostConfiguration hostConfiguration) {
                    List tags = hostConfiguration.getTags();
                    if (tags != null) {
                        for (String matchTag : matchTags) {
                            if (tags.contains(matchTag)) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
            };
        }
        return Filters.trueFilter();
    }

    public static boolean isValidHost(HostConfiguration config, ProfileRequirements profileRequirements, HostProfileCounter hostProfileCounter, String hostAlias) {
        int count;
        Integer maximumInstancesPerHost;
        int count2;
        boolean valid = true;
        String profile = profileRequirements.getProfile();
        Integer maximumContainerCount = config.getMaximumContainerCount();
        if (maximumContainerCount != null && (count2 = hostProfileCounter.containerCount(hostAlias)) >= maximumContainerCount) {
            valid = false;
        }
        if (valid && (maximumInstancesPerHost = profileRequirements.getMaximumInstancesPerHost()) != null && (count = hostProfileCounter.profileCount(hostAlias, profile)) >= maximumInstancesPerHost) {
            valid = false;
        }
        return valid;
    }

    public static Map<String, CountingMap> createHostToProfileScaleMap(HostProfileCounter hostContainerCounts, List<? extends HostConfiguration> hostConfigurations, Container[] containers) {
        HashMap<String, CountingMap> answer = new HashMap<String, CountingMap>();
        if (containers != null && containers != null) {
            for (Container container : containers) {
                String hostAlias = AutoScalers.findHostAlias(hostConfigurations, container);
                if (hostAlias == null) continue;
                hostContainerCounts.incrementContainers(hostAlias);
                List profileIds = Profiles.profileIds((Profile[])container.getProfiles());
                hostContainerCounts.incrementProfilesCount(hostAlias, profileIds);
            }
        }
        return answer;
    }

    protected static String findHostAlias(Collection<? extends HostConfiguration> hostConfigurations, Container container) {
        for (HostConfiguration hostConfiguration : hostConfigurations) {
            String hostName = hostConfiguration.getHostName();
            if (!Objects.equal((Object)hostName, (Object)container.getLocalHostname()) && !Objects.equal((Object)hostName, (Object)container.getLocalIp()) && !Objects.equal((Object)hostName, (Object)container.getPublicHostname()) && !Objects.equal((Object)hostName, (Object)container.getIp()) && !Objects.equal((Object)hostName, (Object)container.getManualIp())) continue;
            return hostName;
        }
        return null;
    }

    public static <T extends HostConfiguration> SortedSet<LoadSortedHostConfiguration<T>> filterHosts(ProfileRequirements profileRequirements, HostScalingRequirements scalingRequirements, HostProfileCounter hostProfileCounter, List<T> hosts) {
        TreeSet<LoadSortedHostConfiguration<T>> answer = new TreeSet<LoadSortedHostConfiguration<T>>();
        int index = 0;
        Filter<String> hostFilter = AutoScalers.createHostAliasFilter(scalingRequirements);
        Filter<HostConfiguration> configFilter = AutoScalers.createHostConfigFilter(scalingRequirements);
        for (HostConfiguration config : hosts) {
            String hostName = config.getHostName();
            if (!hostFilter.matches((Object)hostName) || !configFilter.matches((Object)config)) continue;
            String profile = profileRequirements.getProfile();
            boolean valid = AutoScalers.isValidHost(config, profileRequirements, hostProfileCounter, hostName);
            if (!valid) continue;
            answer.add(new LoadSortedHostConfiguration<HostConfiguration>(hostName, config, profile, hostProfileCounter, index++));
        }
        return answer;
    }
}

