/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.internal;

import io.fabric8.api.AbstractAttributableBuilder;
import io.fabric8.api.Builder;
import io.fabric8.api.OptionsProvider;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.api.VersionBuilder;
import io.fabric8.internal.VersionImpl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.gravia.utils.IllegalStateAssertion;

final class DefaultVersionBuilder
extends AbstractAttributableBuilder<VersionBuilder>
implements VersionBuilder {
    private String versionId;
    private Map<String, Profile> profiles = new LinkedHashMap<String, Profile>();

    DefaultVersionBuilder(String versionId) {
        this.versionId = versionId;
    }

    DefaultVersionBuilder(Version version) {
        this.setAttributes(version.getAttributes());
        this.addProfiles(version.getProfiles());
    }

    public VersionBuilder addOptions(OptionsProvider<VersionBuilder> optionsProvider) {
        return (VersionBuilder)optionsProvider.addOptions((Builder)this);
    }

    public VersionBuilder identity(String versionId) {
        this.versionId = versionId;
        return this;
    }

    public Set<String> getProfiles() {
        return this.profiles.keySet();
    }

    public Profile getProfile(String profileId) {
        return this.profiles.get(profileId);
    }

    public VersionBuilder addProfile(Profile profile) {
        this.profiles.put(profile.getId(), profile);
        return this;
    }

    public VersionBuilder addProfiles(List<Profile> prflist) {
        for (Profile profile : prflist) {
            this.profiles.put(profile.getId(), profile);
        }
        return this;
    }

    public VersionBuilder removeProfile(String profileId) {
        this.profiles.remove(profileId);
        return this;
    }

    protected void validate() {
        super.validate();
        IllegalStateAssertion.assertNotNull((Object)this.versionId, (String)"Version must have an identity");
        for (Profile profile : this.profiles.values()) {
            String prfversion = profile.getVersion();
            IllegalStateAssertion.assertEquals((Object)this.versionId, (Object)prfversion, (String)("Profile version not '" + this.versionId + "' for: " + profile));
        }
    }

    public Version getVersion() {
        this.validate();
        ArrayList<Profile> prflist = new ArrayList<Profile>(this.profiles.values());
        return new VersionImpl(this.versionId, this.getAttributes(), prflist);
    }
}

