/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.ssh;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.api.CreateContainerBasicOptions;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.CreateRemoteContainerOptions;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.api.SshConfiguration;
import io.fabric8.api.SshHostConfiguration;
import io.fabric8.api.jcip.NotThreadSafe;
import io.fabric8.common.util.Strings;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

@NotThreadSafe
public class CreateSshContainerOptions
extends CreateContainerBasicOptions<CreateSshContainerOptions>
implements CreateRemoteContainerOptions {
    private static final long serialVersionUID = -1171578973712670970L;
    public static final String DEFAULT_PRIVATE_KEY_FILE = System.getProperty("user.home") + File.separatorChar + ".ssh" + File.separatorChar + "id_rsa";
    static final int DEFAULT_SSH_RETRIES = 1;
    static final int DEFAULT_SSH_PORT = 22;
    public static final String DEFAULT_PATH = "~/containers/";
    public static final String DEFAULT_USERNAME = "root";
    @JsonProperty
    private final String username;
    @JsonProperty
    private final String password;
    @JsonProperty
    private final String host;
    @JsonProperty
    private final int port;
    @JsonProperty
    private final int sshRetries;
    @JsonProperty
    private final int retryDelay;
    @JsonProperty
    private final String privateKeyFile;
    @JsonProperty
    private final String passPhrase;
    @JsonProperty
    private final String path;
    @JsonProperty
    private final Map<String, String> environmentalVariables;
    @JsonProperty
    private final List<String> fallbackRepositories;

    CreateSshContainerOptions(String bindAddress, String resolver, String globalResolver, String manualIp, int minimumPort, int maximumPort, Set<String> profiles, String version, Map<String, String> dataStoreProperties, int zooKeeperServerPort, int zooKeeperServerConnectionPort, String zookeeperPassword, boolean ensembleStart, boolean agentEnabled, boolean autoImportEnabled, String importPath, Map<String, String> users, String name, String parent, String providerType, boolean ensembleServer, String preferredAddress, Map<String, Properties> systemProperties, int number, URI proxyUri, String zookeeperUrl, String jvmOpts, boolean adminAccess, boolean clean, String username, String password, String host, int port, int sshRetries, int retryDelay, String privateKeyFile, String passPhrase, String path, Map<String, String> environmentalVariables, List<String> fallbackRepositories) {
        super(bindAddress, resolver, globalResolver, manualIp, minimumPort, maximumPort, profiles, version, dataStoreProperties, zooKeeperServerPort, zooKeeperServerConnectionPort, zookeeperPassword, ensembleStart, agentEnabled, false, 0L, autoImportEnabled, importPath, users, name, parent, providerType, ensembleServer, preferredAddress, systemProperties, Integer.valueOf(number), proxyUri, zookeeperUrl, jvmOpts, adminAccess, clean);
        this.username = username;
        this.password = password;
        this.host = host;
        this.port = port;
        this.sshRetries = sshRetries;
        this.retryDelay = retryDelay;
        this.privateKeyFile = privateKeyFile;
        this.passPhrase = passPhrase;
        this.path = path;
        this.fallbackRepositories = fallbackRepositories;
        this.environmentalVariables = Collections.unmodifiableMap(new HashMap<String, String>(environmentalVariables));
    }

    public CreateContainerOptions updateCredentials(String newUser, String newPassword) {
        return new CreateSshContainerOptions(this.getBindAddress(), this.getResolver(), this.getGlobalResolver(), this.getManualIp(), this.getMinimumPort(), this.getMaximumPort(), this.getProfiles(), this.getVersion(), this.getDataStoreProperties(), this.getZooKeeperServerPort(), this.getZooKeeperServerConnectionPort(), this.getZookeeperPassword(), this.isEnsembleStart(), this.isAgentEnabled(), this.isAutoImportEnabled(), this.getImportPath(), this.getUsers(), this.getName(), this.getParent(), "ssh", this.isEnsembleServer(), this.getPreferredAddress(), this.getSystemProperties(), this.getNumber(), this.getProxyUri(), this.getZookeeperUrl(), this.getJvmOpts(), this.isAdminAccess(), this.isClean(), newUser != null ? newUser : this.username, newPassword != null ? newPassword : this.password, this.host, this.port, this.sshRetries, this.retryDelay, this.privateKeyFile, this.passPhrase, this.path, this.environmentalVariables, this.fallbackRepositories);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getSshRetries() {
        return this.sshRetries;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getEnvironmentalVariables() {
        return this.environmentalVariables;
    }

    public String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    public String getHostNameContext() {
        return "none";
    }

    public List<String> getFallbackRepositories() {
        return this.fallbackRepositories;
    }

    public CreateSshContainerOptions clone() throws CloneNotSupportedException {
        return (CreateSshContainerOptions)((Object)super.clone());
    }

    public String toString() {
        return "createSshContainer(" + this.getUsername() + "@" + this.getHost() + ":" + this.getPort() + " " + this.getPath() + ")";
    }

    public static class Builder
    extends CreateContainerBasicOptions.Builder<Builder> {
        @JsonProperty
        private String username;
        @JsonProperty
        private String password;
        @JsonProperty
        private String host;
        @JsonProperty
        private int port = 22;
        @JsonProperty
        private int sshRetries = 1;
        @JsonProperty
        private int retryDelay = 1;
        @JsonProperty
        private String privateKeyFile = DEFAULT_PRIVATE_KEY_FILE;
        @JsonProperty
        private String passPhrase;
        @JsonProperty
        private String path = "~/containers/";
        @JsonProperty
        private Map<String, String> environmentalVariables = new HashMap<String, String>();
        @JsonProperty
        private List<String> fallbackRepositories = new ArrayList<String>();

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder environmentalVariables(Map<String, String> environmentalVariables) {
            this.environmentalVariables = environmentalVariables;
            return this;
        }

        public Builder environmentalVariable(String key, String value) {
            this.environmentalVariables.put(key, value);
            return this;
        }

        public Builder environmentalVariable(String entry) {
            if (entry.contains("=")) {
                String key = entry.substring(0, entry.indexOf("="));
                String value = entry.substring(entry.indexOf("=") + 1);
                this.environmentalVariable(key, value);
            }
            return this;
        }

        public Builder environmentalVariable(List<String> entries) {
            if (entries != null) {
                for (String entry : entries) {
                    this.environmentalVariable(entry);
                }
            }
            return this;
        }

        public Builder sshRetries(int sshRetries) {
            this.sshRetries = sshRetries;
            return this;
        }

        public Builder retryDelay(int retryDelay) {
            this.retryDelay = retryDelay;
            return this;
        }

        public Builder privateKeyFile(String privateKeyFile) {
            this.privateKeyFile = privateKeyFile;
            return this;
        }

        public Builder passPhrase(String passPhrase) {
            this.passPhrase = passPhrase;
            return this;
        }

        public Builder fallbackRepositories(List<String> fallbackRepositories) {
            this.fallbackRepositories = fallbackRepositories;
            return this;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public int getSshRetries() {
            return this.sshRetries;
        }

        public void setSshRetries(int sshRetries) {
            this.sshRetries = sshRetries;
        }

        public int getRetryDelay() {
            return this.retryDelay;
        }

        public void setRetryDelay(int retryDelay) {
            this.retryDelay = retryDelay;
        }

        public String getPrivateKeyFile() {
            return this.privateKeyFile;
        }

        public void setPrivateKeyFile(String privateKeyFile) {
            this.privateKeyFile = privateKeyFile;
        }

        public String getPassPhrase() {
            return this.passPhrase;
        }

        public void setPassPhrase(String passPhrase) {
            this.passPhrase = passPhrase;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setEnvironmentalVariables(Map<String, String> environmentalVariables) {
            this.environmentalVariables = environmentalVariables;
        }

        public List<String> getFallbackRepositories() {
            return this.fallbackRepositories;
        }

        public void setFallbackRepositories(List<String> fallbackRepositories) {
            this.fallbackRepositories = fallbackRepositories;
        }

        public CreateSshContainerOptions build() {
            return new CreateSshContainerOptions(this.getBindAddress(), this.getResolver(), this.getGlobalResolver(), this.getManualIp(), this.getMinimumPort(), this.getMaximumPort(), this.getProfiles(), this.getVersion(), this.getDataStoreProperties(), this.getZooKeeperServerPort(), this.getZooKeeperServerConnectionPort(), this.getZookeeperPassword(), this.isEnsembleStart(), this.isAgentEnabled(), this.isAutoImportEnabled(), this.getImportPath(), this.getUsers(), this.getName(), this.getParent(), "ssh", this.isEnsembleServer(), this.getPreferredAddress(), this.getSystemProperties(), this.getNumber(), this.getProxyUri(), this.getZookeeperUrl(), this.getJvmOpts(), this.isAdminAccess(), false, this.username, this.password, this.host, this.port, this.sshRetries, this.retryDelay, this.privateKeyFile, this.passPhrase, this.path, this.environmentalVariables, this.fallbackRepositories);
        }

        public void configure(SshHostConfiguration sshHostConfig, FabricRequirements requirements, ProfileRequirements profileRequirements) {
            Integer portValue;
            SshConfiguration sshHosts = requirements.getSshConfiguration();
            this.host = sshHostConfig.getHostName();
            if (Strings.isNullOrBlank((String)this.host)) {
                throw new IllegalArgumentException("Missing host property in the ssh configuration: " + sshHostConfig);
            }
            String preferredAddress = this.getPreferredAddress();
            if (Strings.isNullOrBlank((String)preferredAddress)) {
                preferredAddress = sshHostConfig.getPreferredAddress();
                if (Strings.isNullOrBlank((String)preferredAddress)) {
                    preferredAddress = this.host;
                }
                this.preferredAddress(preferredAddress);
            }
            this.path = sshHostConfig.getPath();
            if (Strings.isNullOrBlank((String)this.path)) {
                if (sshHosts != null) {
                    this.path = sshHosts.getDefaultPath();
                }
                if (Strings.isNullOrBlank((String)this.path)) {
                    this.path = CreateSshContainerOptions.DEFAULT_PATH;
                }
            }
            if ((portValue = sshHostConfig.getPort()) == null && sshHosts != null) {
                portValue = sshHosts.getDefaultPort();
            }
            this.port = portValue != null ? portValue : 22;
            this.username = sshHostConfig.getUsername();
            if (Strings.isNullOrBlank((String)this.username)) {
                if (sshHosts != null) {
                    this.username = sshHosts.getDefaultUsername();
                }
                if (Strings.isNullOrBlank((String)this.username)) {
                    this.username = CreateSshContainerOptions.DEFAULT_USERNAME;
                }
            }
            this.password = sshHostConfig.getPassword();
            if (Strings.isNullOrBlank((String)this.password) && sshHosts != null) {
                this.password = sshHosts.getDefaultPassword();
            }
            if (sshHosts != null) {
                this.fallbackRepositories = sshHosts.getFallbackRepositories();
            }
            this.passPhrase = sshHostConfig.getPassPhrase();
            if (Strings.isNullOrBlank((String)this.passPhrase) && sshHosts != null) {
                this.passPhrase = sshHosts.getDefaultPassPhrase();
            }
            this.privateKeyFile = sshHostConfig.getPrivateKeyFile();
            if (Strings.isNullOrBlank((String)this.privateKeyFile)) {
                if (sshHosts != null) {
                    this.privateKeyFile = sshHosts.getDefaultPrivateKeyFile();
                }
                if (Strings.isNullOrBlank((String)this.privateKeyFile)) {
                    this.privateKeyFile = DEFAULT_PRIVATE_KEY_FILE;
                }
            }
        }
    }
}

