/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.boot.commands.support;

import io.fabric8.api.FabricService;
import io.fabric8.api.Version;
import io.fabric8.boot.commands.support.AbstractCompleterComponent;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;

@Component(immediate=true)
@Service(value={VersionCompleter.class, Completer.class})
public final class VersionCompleter
extends AbstractCompleterComponent {
    @Reference
    private FabricService fabricService;

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    @Override
    public String getParameter() {
        return "--version";
    }

    public int complete(String buffer, int cursor, List<String> candidates) {
        Version[] versions;
        StringsCompleter delegate = new StringsCompleter();
        for (Version version : versions = this.fabricService.getVersions()) {
            delegate.getStrings().add(version.getId());
        }
        return delegate.complete(buffer, cursor, candidates);
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    protected void bindFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    protected void unbindFabricService(FabricService fabricService) {
        if (this.fabricService == fabricService) {
            this.fabricService = null;
        }
    }
}

