/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.ProfileRegistry;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Version;
import java.io.File;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="profile-export", scope="fabric", description="Exports all matching profile folders into the given output zip file")
public class ProfileExportAction
extends AbstractAction {
    @Option(name="--version", description="The profile version to export profiles from. Defaults to the current version if none specified.")
    private String version;
    @Argument(index=0, required=true, name="outputZipFileName", description="The output file name of the generated ZIP of the profiles")
    private File outputZipFileName;
    @Argument(index=1, required=false, name="wildcard", description="The file wildcard used to match the profile folders. e.g. 'examples/*'. If no wildcard is specified all profiles will be exported")
    private String wildcard;
    private final FabricService fabricService;
    private final ProfileService profileService;

    ProfileExportAction(FabricService fabricService) {
        this.fabricService = fabricService;
        this.profileService = (ProfileService)fabricService.adapt(ProfileService.class);
    }

    protected Object doExecute() throws Exception {
        Version ver;
        Version version = ver = this.version != null ? this.profileService.getVersion(this.version) : this.fabricService.getDefaultVersion();
        if (ver == null) {
            if (this.version != null) {
                System.out.println("Version " + this.version + " does not exist!");
            } else {
                System.out.println("No default version available!");
            }
            return null;
        }
        ((ProfileRegistry)this.fabricService.adapt(ProfileRegistry.class)).exportProfiles(ver.getId(), this.outputZipFileName.getAbsolutePath(), this.wildcard);
        System.out.println("Exported profiles to " + this.outputZipFileName.getCanonicalPath());
        return null;
    }
}

