/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileBuilder;
import io.fabric8.api.ProfileRegistry;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Version;
import io.fabric8.utils.FabricValidations;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import jline.Terminal;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;
import org.jledit.ConsoleEditor;
import org.jledit.ContentManager;
import org.jledit.EditorFactory;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(name="profile-edit", scope="fabric", description="Edits the specified version of the specified profile", detailedDescription="classpath:profileEdit.txt")
public class ProfileEditAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileEditAction.class);
    static final String FEATURE_PREFIX = "feature.";
    static final String REPOSITORY_PREFIX = "repository.";
    static final String BUNDLE_PREFIX = "bundle.";
    static final String FAB_PREFIX = "fab.";
    static final String OVERRIDE_PREFIX = "override.";
    static final String CONFIG_PREFIX = "config.";
    static final String SYSTEM_PREFIX = "system.";
    static final String LIB_PREFIX = "lib.";
    static final String ENDORSED_PREFIX = "endorsed.";
    static final String EXT_PREFIX = "ext.";
    static final String DELIMITER = ",";
    static final String PID_KEY_SEPARATOR = "/";
    static final String FILE_INSTALL_FILENAME_PROPERTY = "felix.fileinstall.filename";
    @Option(name="-r", aliases={"--repositories"}, description="Edit the features repositories. To specify multiple repositories, specify this flag multiple times.", required=false, multiValued=true)
    private String[] repositories;
    @Option(name="-f", aliases={"--features"}, description="Edit features. To specify multiple features, specify this flag multiple times. For example, --features foo --features bar.", required=false, multiValued=true)
    private String[] features;
    @Option(name="-l", aliases={"--libs"}, description="Edit libraries. To specify multiple libraries, specify this flag multiple times.", required=false, multiValued=true)
    private String[] libs;
    @Option(name="-n", aliases={"--endorsed"}, description="Edit endorsed libraries. To specify multiple libraries, specify this flag multiple times.", required=false, multiValued=true)
    private String[] endorsed;
    @Option(name="-x", aliases={"--extension"}, description="Edit extension libraries. To specify multiple libraries, specify this flag multiple times.", required=false, multiValued=true)
    private String[] extension;
    @Option(name="-b", aliases={"--bundles"}, description="Edit bundles. To specify multiple bundles, specify this flag multiple times.", required=false, multiValued=true)
    private String[] bundles;
    @Option(name="--fabs", description="Edit fabs. To specify multiple fabs, specify this flag multiple times.", required=false, multiValued=true)
    private String[] fabs;
    @Option(name="-o", aliases={"--overrides"}, description="Edit overrides. To specify multiple libraries, specify this flag multiple times.", required=false, multiValued=true)
    private String[] overrides;
    @Option(name="-p", aliases={"--pid"}, description="Edit an OSGi configuration property, specified in the format <PID>/<Property>. To specify multiple properties, specify this flag multiple times.", required=false, multiValued=true)
    private String[] pidProperties;
    @Option(name="-s", aliases={"--system"}, description="Edit the Java system properties that affect installed bundles (analogous to editing etc/system.properties in a root container).", required=false, multiValued=true)
    private String[] systemProperties;
    @Option(name="-c", aliases={"--config"}, description="Edit the Java system properties that affect the karaf container (analogous to editing etc/config.properties in a root container).", required=false, multiValued=true)
    private String[] configProperties;
    @Option(name="-i", aliases={"--import-pid"}, description="Imports the pids that are edited, from local OSGi config admin", required=false, multiValued=false)
    private boolean importPid = false;
    @Option(name="--resource", description="Selects a resource under the profile to edit. This option should only be used alone.", required=false, multiValued=false)
    private String resource;
    @Option(name="--set", description="Set or create values (selected by default).")
    private boolean set = true;
    @Option(name="--delete", description="Delete values. This option can be used to delete a feature, a bundle or a pid from the profile.")
    private boolean delete = false;
    @Option(name="--append", description="Append value to a delimited list. It is only usable with the system, config & pid options")
    private boolean append = false;
    @Option(name="--remove", description="Removes value from a delimited list. It is only usable with the system, config & pid options")
    private boolean remove = false;
    @Option(name="--delimiter", description="Specifies the delimiter to use for appends and removals.")
    private String delimiter = ",";
    @Argument(index=0, name="profile", description="The target profile to edit", required=true, multiValued=false)
    private String profileName;
    @Argument(index=1, name="version", description="The version of the profile to edit. Defaults to the current default version.", required=false, multiValued=false)
    private String versionId;
    private final ProfileService profileService;
    private final FabricService fabricService;
    private final ConfigurationAdmin configurationAdmin;
    private final EditorFactory editorFactory;

    ProfileEditAction(FabricService fabricService, ConfigurationAdmin configurationAdmin, EditorFactory editorFactory) {
        this.profileService = (ProfileService)fabricService.adapt(ProfileService.class);
        this.fabricService = fabricService;
        this.configurationAdmin = configurationAdmin;
        this.editorFactory = editorFactory;
    }

    protected Object doExecute() throws Exception {
        Version version;
        Profile profile;
        FabricValidations.validateProfileName(this.profileName);
        if (this.delete) {
            this.set = false;
        }
        if ((profile = (version = this.versionId != null ? this.profileService.getRequiredVersion(this.versionId) : this.fabricService.getRequiredDefaultVersion()).getProfile(this.profileName)) != null) {
            this.editProfile(profile);
        } else {
            System.out.println("Profile " + this.profileName + " does not exists!");
        }
        return null;
    }

    private void editProfile(Profile profile) throws Exception {
        boolean editInLine = false;
        ProfileBuilder builder = ProfileBuilder.Factory.createFrom((Profile)profile);
        if (this.delete || this.remove) {
            editInLine = true;
        }
        if (this.features != null && this.features.length > 0) {
            editInLine = true;
            this.handleFeatures(builder, this.features, profile);
        }
        if (this.repositories != null && this.repositories.length > 0) {
            editInLine = true;
            this.handleFeatureRepositories(builder, this.repositories, profile);
        }
        if (this.libs != null && this.libs.length > 0) {
            editInLine = true;
            this.handleLibraries(builder, this.libs, profile, "lib", LIB_PREFIX);
        }
        if (this.endorsed != null && this.endorsed.length > 0) {
            editInLine = true;
            this.handleLibraries(builder, this.endorsed, profile, "endorsed lib", ENDORSED_PREFIX);
        }
        if (this.extension != null && this.extension.length > 0) {
            editInLine = true;
            this.handleLibraries(builder, this.extension, profile, "extension lib", EXT_PREFIX);
        }
        if (this.bundles != null && this.bundles.length > 0) {
            editInLine = true;
            this.handleBundles(builder, this.bundles, profile);
        }
        if (this.fabs != null && this.fabs.length > 0) {
            editInLine = true;
            this.handleFabs(builder, this.fabs, profile);
        }
        if (this.overrides != null && this.overrides.length > 0) {
            editInLine = true;
            this.handleOverrides(builder, this.overrides, profile);
        }
        if (this.pidProperties != null && this.pidProperties.length > 0) {
            editInLine = this.handlePid(builder, this.pidProperties, profile);
        }
        if (this.systemProperties != null && this.systemProperties.length > 0) {
            editInLine = true;
            this.handleSystemProperties(builder, this.systemProperties, profile);
        }
        if (this.configProperties != null && this.configProperties.length > 0) {
            editInLine = true;
            this.handleConfigProperties(builder, this.configProperties, profile);
        }
        if (!editInLine) {
            String string = this.resource = this.resource != null ? this.resource : "io.fabric8.agent.properties";
            if (this.pidProperties != null && this.pidProperties.length == 1) {
                this.resource = this.pidProperties[0] + ".properties";
            }
            this.openInEditor(profile, this.resource);
        }
        this.profileService.updateProfile(builder.getProfile());
    }

    private void handleFeatures(ProfileBuilder builder, String[] features, Profile profile) {
        Map<String, String> conf = this.getConfigurationFromBuilder(builder, "io.fabric8.agent");
        for (String feature : features) {
            if (this.delete) {
                System.out.println("Deleting feature:" + feature + " from profile:" + profile.getId() + " version:" + profile.getVersion());
            } else {
                System.out.println("Adding feature:" + feature + " to profile:" + profile.getId() + " version:" + profile.getVersion());
            }
            this.updateConfig(conf, FEATURE_PREFIX + feature.replace('/', '_'), feature, this.set, this.delete);
            builder.addConfiguration("io.fabric8.agent", conf);
        }
    }

    private void handleFeatureRepositories(ProfileBuilder builder, String[] repositories, Profile profile) {
        Map<String, String> conf = this.getConfigurationFromBuilder(builder, "io.fabric8.agent");
        for (String repositoryURI : repositories) {
            if (this.set) {
                System.out.println("Adding feature repository:" + repositoryURI + " to profile:" + profile.getId() + " version:" + profile.getVersion());
            } else if (this.delete) {
                System.out.println("Deleting feature repository:" + repositoryURI + " from profile:" + profile.getId() + " version:" + profile.getVersion());
            }
            this.updateConfig(conf, REPOSITORY_PREFIX + repositoryURI.replace('/', '_'), repositoryURI, this.set, this.delete);
        }
        builder.addConfiguration("io.fabric8.agent", conf);
    }

    private void handleLibraries(ProfileBuilder builder, String[] libs, Profile profile, String libType, String libPrefix) {
        Map<String, String> conf = this.getConfigurationFromBuilder(builder, "io.fabric8.agent");
        for (String lib : libs) {
            if (this.set) {
                System.out.println("Adding " + libType + ":" + lib + " to profile:" + profile.getId() + " version:" + profile.getVersion());
            } else if (this.delete) {
                System.out.println("Deleting " + libType + ":" + lib + " from profile:" + profile.getId() + " version:" + profile.getVersion());
            }
            this.updateConfig(conf, libPrefix + lib.replace('/', '_'), lib, this.set, this.delete);
        }
        builder.addConfiguration("io.fabric8.agent", conf);
    }

    private void handleBundles(ProfileBuilder builder, String[] bundles, Profile profile) {
        Map<String, String> conf = this.getConfigurationFromBuilder(builder, "io.fabric8.agent");
        for (String bundle : bundles) {
            if (this.set) {
                System.out.println("Adding bundle:" + bundle + " to profile:" + profile.getId() + " version:" + profile.getVersion());
            } else if (this.delete) {
                System.out.println("Deleting bundle:" + bundle + " from profile:" + profile.getId() + " version:" + profile.getVersion());
            }
            this.updateConfig(conf, BUNDLE_PREFIX + bundle.replace('/', '_'), bundle, this.set, this.delete);
        }
        builder.addConfiguration("io.fabric8.agent", conf);
    }

    private void handleFabs(ProfileBuilder builder, String[] fabs, Profile profile) {
        Map<String, String> conf = this.getConfigurationFromBuilder(builder, "io.fabric8.agent");
        for (String fab : fabs) {
            if (this.set) {
                System.out.println("Adding FAB:" + fab + " to profile:" + profile.getId() + " version:" + profile.getVersion());
            } else if (this.delete) {
                System.out.println("Deleting FAB:" + fab + " from profile:" + profile.getId() + " version:" + profile.getVersion());
            }
            this.updateConfig(conf, FAB_PREFIX + fab.replace('/', '_'), fab, this.set, this.delete);
        }
        builder.addConfiguration("io.fabric8.agent", conf);
    }

    private void handleOverrides(ProfileBuilder builder, String[] overrides, Profile profile) {
        Map<String, String> conf = this.getConfigurationFromBuilder(builder, "io.fabric8.agent");
        for (String override : overrides) {
            if (this.set) {
                System.out.println("Adding override:" + override + " to profile:" + profile.getId() + " version:" + profile.getVersion());
            } else if (this.delete) {
                System.out.println("Deleting override:" + override + " from profile:" + profile.getId() + " version:" + profile.getVersion());
            }
            this.updateConfig(conf, OVERRIDE_PREFIX + override.replace('/', '_'), override, this.set, this.delete);
        }
        builder.addConfiguration("io.fabric8.agent", conf);
    }

    private boolean handlePid(ProfileBuilder builder, String[] pidProperties, Profile profile) {
        boolean editInline = true;
        for (String pidProperty : pidProperties) {
            String currentPid = null;
            String keyValuePair = "";
            if (pidProperty.contains(PID_KEY_SEPARATOR)) {
                currentPid = pidProperty.substring(0, pidProperty.indexOf(PID_KEY_SEPARATOR));
                keyValuePair = pidProperty.substring(pidProperty.indexOf(PID_KEY_SEPARATOR) + 1);
            } else {
                currentPid = pidProperty;
            }
            Map<String, String> conf = this.getConfigurationFromBuilder(builder, currentPid);
            if (pidProperties.length == 1 && this.importPid) {
                System.out.println("Importing pid:" + currentPid + " to profile:" + profile.getId() + " version:" + profile.getVersion());
                this.importPidFromLocalConfigAdmin(currentPid, conf);
                builder.addConfiguration(currentPid, conf);
                return true;
            }
            Map<String, String> configMap = this.extractConfigs(keyValuePair);
            if (configMap.isEmpty() && this.set) {
                editInline = false;
                continue;
            }
            if (configMap.isEmpty() && this.delete) {
                editInline = true;
                System.out.println("Deleting pid:" + currentPid + " from profile:" + profile.getId() + " version:" + profile.getVersion());
                builder.deleteConfiguration(currentPid);
                continue;
            }
            for (Map.Entry<String, String> configEntries : configMap.entrySet()) {
                String key = configEntries.getKey();
                String value = configEntries.getValue();
                if (value == null && this.delete) {
                    System.out.println("Deleting key:" + key + " from pid:" + currentPid + " and profile:" + profile.getId() + " version:" + profile.getVersion());
                    conf.remove(key);
                    continue;
                }
                if (this.append) {
                    System.out.println("Appending value:" + value + " key:" + key + " to pid:" + currentPid + " and profile:" + profile.getId() + " version:" + profile.getVersion());
                } else if (this.remove) {
                    System.out.println("Removing value:" + value + " key:" + key + " from pid:" + currentPid + " and profile:" + profile.getId() + " version:" + profile.getVersion());
                } else if (this.set) {
                    System.out.println("Setting value:" + value + " key:" + key + " on pid:" + currentPid + " and profile:" + profile.getId() + " version:" + profile.getVersion());
                }
                this.updatedDelimitedList(conf, key, value, this.delimiter, this.set, this.delete, this.append, this.remove);
            }
            editInline = true;
            builder.addConfiguration(currentPid, conf);
        }
        return editInline;
    }

    private void handleSystemProperties(ProfileBuilder builder, String[] systemProperties, Profile profile) {
        Map<String, String> conf = this.getConfigurationFromBuilder(builder, "io.fabric8.agent");
        for (String systemProperty : systemProperties) {
            Map<String, String> configMap = this.extractConfigs(systemProperty);
            for (Map.Entry<String, String> configEntries : configMap.entrySet()) {
                String key = configEntries.getKey();
                String value = configEntries.getValue();
                if (this.append) {
                    System.out.println("Appending value:" + value + " key:" + key + " from system properties and profile:" + profile.getId() + " version:" + profile.getVersion());
                } else if (this.delete) {
                    System.out.println("Deleting key:" + key + " from system properties and profile:" + profile.getId() + " version:" + profile.getVersion());
                } else if (this.set) {
                    System.out.println("Setting value:" + value + " key:" + key + " from system properties and profile:" + profile.getId() + " version:" + profile.getVersion());
                } else {
                    System.out.println("Removing value:" + value + " key:" + key + " from system properties and profile:" + profile.getId() + " version:" + profile.getVersion());
                }
                this.updatedDelimitedList(conf, SYSTEM_PREFIX + key, value, this.delimiter, this.set, this.delete, this.append, this.remove);
            }
        }
        builder.addConfiguration("io.fabric8.agent", conf);
    }

    private void handleConfigProperties(ProfileBuilder builder, String[] configProperties, Profile profile) {
        Map<String, String> conf = this.getConfigurationFromBuilder(builder, "io.fabric8.agent");
        for (String configProperty : configProperties) {
            Map<String, String> configMap = this.extractConfigs(configProperty);
            for (Map.Entry<String, String> configEntries : configMap.entrySet()) {
                String key = configEntries.getKey();
                String value = configEntries.getValue();
                if (this.append) {
                    System.out.println("Appending value:" + value + " key:" + key + " from config properties and profile:" + profile + " version:" + this.versionId);
                } else if (this.delete) {
                    System.out.println("Deleting key:" + key + " from config properties and profile:" + profile + " version:" + this.versionId);
                } else if (this.set) {
                    System.out.println("Setting value:" + value + " key:" + key + " from config properties and profile:" + profile + " version:" + this.versionId);
                }
                this.updatedDelimitedList(conf, CONFIG_PREFIX + key, value, this.delimiter, this.set, this.delete, this.append, this.remove);
            }
        }
        builder.addConfiguration("io.fabric8.agent", conf);
    }

    private void openInEditor(Profile profile, String resource) throws Exception {
        String id = profile.getId();
        String version = profile.getVersion();
        String location = id + " " + version + " " + resource;
        ConsoleEditor editor = this.editorFactory.create("simple", this.getTerminal(), System.in, System.out);
        editor.setTitle("Profile");
        editor.setOpenEnabled(false);
        editor.setContentManager((ContentManager)new DatastoreContentManager(this.fabricService));
        editor.open(location, id + " " + version);
        editor.start();
    }

    public void updatedDelimitedList(Map<String, String> map, String key, String value, String delimiter, boolean set, boolean delete, boolean append, boolean remove) {
        if (append || remove) {
            String oldValue = map.containsKey(key) ? map.get(key) : "";
            LinkedList<String> parts = new LinkedList<String>(Arrays.asList(oldValue.split(delimiter)));
            parts.remove("");
            if (append) {
                parts.add(value);
            }
            if (remove) {
                parts.remove(value);
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parts.size(); ++i) {
                if (i != 0) {
                    sb.append(delimiter);
                }
                sb.append((String)parts.get(i));
            }
            map.put(key, sb.toString());
        } else if (set) {
            map.put(key, value);
        } else if (delete) {
            map.remove(key);
        }
    }

    private void updateConfig(Map<String, String> map, String key, String value, boolean set, boolean delete) {
        if (set) {
            map.put(key, value);
        } else if (delete) {
            map.remove(key);
        }
    }

    private void importPidFromLocalConfigAdmin(String pid, Map<String, String> target) {
        try {
            Configuration[] configuration = this.configurationAdmin.listConfigurations("(service.pid=" + pid + ")");
            if (configuration != null && configuration.length > 0) {
                Dictionary dictionary = configuration[0].getProperties();
                Enumeration keyEnumeration = dictionary.keys();
                while (keyEnumeration.hasMoreElements()) {
                    String key = String.valueOf(keyEnumeration.nextElement());
                    if (key.equals(FILE_INSTALL_FILENAME_PROPERTY)) continue;
                    String value = String.valueOf(dictionary.get(key));
                    target.put(key, value);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error while importing configuration {} to profile.", (Object)pid);
        }
    }

    private Map<String, String> extractConfigs(String configs) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        String key = null;
        String value = null;
        if (configs.contains("=")) {
            key = configs.substring(0, configs.indexOf("="));
            value = configs.substring(configs.indexOf("=") + 1);
        } else {
            key = configs;
            value = null;
        }
        if (key != null && !key.isEmpty()) {
            configMap.put(key, value);
        }
        return configMap;
    }

    private Terminal getTerminal() throws Exception {
        Object terminalObject = this.session.get(".jline.terminal");
        if (terminalObject instanceof Terminal) {
            return (Terminal)terminalObject;
        }
        throw new IllegalStateException("Could not get Terminal from CommandSession.");
    }

    private Map<String, String> getConfigurationFromBuilder(ProfileBuilder builder, String pid) {
        Map config = builder.getConfiguration(pid);
        return config != null ? new HashMap<String, String>(config) : new HashMap();
    }

    static class DatastoreContentManager
    implements ContentManager {
        private static final Charset UTF_8 = Charset.forName("UTF-8");
        private final ProfileRegistry profileRegistry;

        public DatastoreContentManager(FabricService fabricService) {
            this.profileRegistry = (ProfileRegistry)fabricService.adapt(ProfileRegistry.class);
        }

        public String load(String location) throws IOException {
            try {
                String[] parts = location.trim().split(" ");
                if (parts.length < 3) {
                    throw new IllegalArgumentException("Invalid location:" + location);
                }
                String profileId = parts[0];
                String versionId = parts[1];
                String resource = parts[2];
                Profile profile = this.profileRegistry.getRequiredProfile(versionId, profileId);
                String data = new String(profile.getFileConfiguration(resource));
                return data != null ? data : "";
            }
            catch (Exception e) {
                throw new IOException("Failed to read data from zookeeper.", e);
            }
        }

        public boolean save(String content, String location) {
            try {
                String[] parts = location.trim().split(" ");
                if (parts.length < 3) {
                    throw new IllegalArgumentException("Invalid location:" + location);
                }
                String profileId = parts[0];
                String versionId = parts[1];
                String resource = parts[2];
                Profile profile = this.profileRegistry.getRequiredProfile(versionId, profileId);
                ProfileBuilder builder = ProfileBuilder.Factory.createFrom((Profile)profile);
                builder.addFileConfiguration(resource, content.getBytes());
                this.profileRegistry.updateProfile(builder.getProfile());
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public boolean save(String content, Charset charset, String location) {
            return this.save(content, location);
        }

        public Charset detectCharset(String location) {
            return UTF_8;
        }
    }
}

