/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Version;
import io.fabric8.utils.shell.ShellUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="patch-apply", scope="fabric", description="Apply the given patch to the default version")
public class PatchApplyAction
extends AbstractAction {
    @Option(name="-u", aliases={"--username"}, description="Remote user name", required=false, multiValued=false)
    private String username;
    @Option(name="-p", aliases={"--password"}, description="Remote user password", required=false, multiValued=false)
    private String password;
    @Option(name="--version", description="Only apply upgrades for the given version instead of the default one")
    private String versionId;
    @Option(name="--all-versions", description="Apply patch to all versions instead of the default one")
    private boolean allVersions;
    @Argument
    private URL patch;
    private final FabricService fabricService;

    PatchApplyAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    protected Object doExecute() throws Exception {
        List<Object> versions;
        ProfileService profileService = (ProfileService)this.fabricService.adapt(ProfileService.class);
        if (this.versionId != null && !this.versionId.isEmpty()) {
            Version version = profileService.getRequiredVersion(this.versionId);
            versions = Collections.singletonList(version);
        } else if (this.allVersions) {
            versions = new ArrayList();
            for (String string : profileService.getVersions()) {
                versions.add(profileService.getRequiredVersion(string));
            }
        } else {
            versions = Collections.singletonList(this.fabricService.getRequiredDefaultVersion());
        }
        this.username = this.username != null && !this.username.isEmpty() ? this.username : ShellUtils.retrieveFabricUser(this.session);
        this.password = this.password != null ? this.password : ShellUtils.retrieveFabricUserPassword(this.session);
        for (Version version : versions) {
            this.fabricService.getPatchService().applyPatch(version, this.patch, this.username, this.password);
        }
        return null;
    }
}

