/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.mxbean;

import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.api.VersionBuilder;
import io.fabric8.api.mxbean.ProfileState;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class VersionState {
    private final Version delegate;

    @ConstructorProperties(value={"id", "revision", "attributes", "profileStates"})
    public VersionState(String versionId, String revision, Map<String, String> attributes, List<ProfileState> profileStates) {
        VersionBuilder builder = VersionBuilder.Factory.create(versionId);
        builder.setRevision(revision);
        if (attributes != null) {
            builder.setAttributes(attributes);
        }
        if (profileStates != null) {
            for (ProfileState ps : profileStates) {
                builder.addProfile(ps.toProfile());
            }
        }
        this.delegate = builder.getVersion();
    }

    public VersionState(Version Version2) {
        this.delegate = Version2;
    }

    public Version toVersion() {
        return this.delegate;
    }

    public String getId() {
        return this.delegate.getId();
    }

    public String getRevision() {
        return this.delegate.getRevision();
    }

    public Map<String, String> getAttributes() {
        return this.delegate.getAttributes();
    }

    public List<String> getProfiles() {
        return this.delegate.getProfileIds();
    }

    public List<ProfileState> getProfileStates() {
        ArrayList<ProfileState> result = new ArrayList<ProfileState>();
        for (Profile prf : this.delegate.getProfiles()) {
            result.add(new ProfileState(prf));
        }
        return result;
    }

    public ProfileState getProfileState(String profileId) {
        Profile prf = this.delegate.getProfile(profileId);
        return new ProfileState(prf);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VersionState)) {
            return false;
        }
        VersionState other = (VersionState)obj;
        return this.delegate.equals(other.delegate);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

