/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.scr.support;

import io.fabric8.api.scr.support.ConverterHelper;
import io.fabric8.api.scr.support.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigInjection {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigInjection.class);

    public static <T> void applyConfiguration(Map<String, ?> configuration, T target, String ... ignorePrefixes) throws Exception {
        for (Class<?> clazz = target.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            ConfigInjection.applyConfiguration(configuration, target, clazz, ignorePrefixes);
        }
    }

    private static <T> void applyConfiguration(Map<String, ?> configuration, T target, Class<?> clazz, String ... ignorePrefixes) throws Exception {
        ConfigInjection.injectValues(clazz, target, configuration, ignorePrefixes);
    }

    private static void injectValues(Class<?> clazz, Object instance, Map<String, ?> configuration, String ... ignorePrefixes) throws Exception {
        for (Map.Entry<String, ?> entry : configuration.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            try {
                Object convertedValue;
                Field field = clazz.getDeclaredField(ConfigInjection.normalizePropertyName(name, ignorePrefixes));
                if (field == null || (convertedValue = ConverterHelper.convertValue(value, field.getGenericType())) == null) continue;
                ReflectionHelper.setField(field, instance, convertedValue);
            }
            catch (NoSuchFieldException e) {
                LOG.debug("No matching field for property with name {}.", (Object)name);
            }
        }
    }

    static String stripPrefixes(String name, String ... prefixes) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        String result = name;
        for (String prefix : prefixes) {
            if (!result.startsWith(prefix)) continue;
            result = result.substring(prefix.length());
        }
        return result;
    }

    static String normalizePropertyName(String name, String ... ignorePrefixes) {
        if (ignorePrefixes.length > 0) {
            return ConfigInjection.normalizePropertyName(ConfigInjection.stripPrefixes(name, ignorePrefixes), new String[0]);
        }
        if (name == null || name.isEmpty()) {
            return name;
        }
        if (!name.contains(".") && !name.contains("-")) {
            return name;
        }
        String[] parts = name.replaceAll(" ", "").split("-|\\.");
        StringBuilder sb = new StringBuilder();
        if (parts.length > 0) {
            sb.append(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                String s = parts[i - 1].length() > 0 ? parts[i].substring(0, 1).toUpperCase() + parts[i].substring(1) : parts[i];
                sb.append(s);
            }
        }
        return sb.toString();
    }
}

