/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public final class ServiceLocator {
    public static final Long DEFAULT_TIMEOUT = 60000L;

    private ServiceLocator() {
    }

    public static <T> T awaitService(BundleContext bundleContext, Class<T> type) {
        return ServiceLocator.awaitService(bundleContext, type, null, DEFAULT_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public static <T> T awaitService(BundleContext bundleContext, Class<T> type, long timeout, TimeUnit unit) {
        return ServiceLocator.awaitService(bundleContext, type, null, timeout, unit);
    }

    public static <T> T awaitService(BundleContext bundleContext, Class<T> type, String filter) {
        return ServiceLocator.awaitService(bundleContext, type, filter, DEFAULT_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public static <T> T awaitService(final BundleContext bundleContext, Class<T> type, String filterspec, long timeout, TimeUnit unit) {
        Filter srvfilter;
        try {
            srvfilter = filterspec != null ? FrameworkUtil.createFilter((String)filterspec) : null;
        }
        catch (InvalidSyntaxException ex) {
            throw new IllegalArgumentException("Invalid filter", ex);
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference serviceRef = new AtomicReference();
        tracker.open();
        try (ServiceTracker tracker = new ServiceTracker<T, T>(bundleContext, type, null){

            public T addingService(ServiceReference<T> sref) {
                Object service = super.addingService(sref);
                if (srvfilter == null || srvfilter.match(sref)) {
                    serviceRef.set(bundleContext.getService(sref));
                    latch.countDown();
                }
                return service;
            }
        };){
            if (!latch.await(timeout, unit)) {
                throw new RuntimeException("Cannot obtain service: " + srvfilter);
            }
            Object v = serviceRef.get();
            return (T)v;
        }
    }
}

