/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.scr.support;

import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class ReflectionHelper {
    private ReflectionHelper() {
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc) throws IllegalArgumentException {
        Class<?> targetClass = clazz;
        do {
            Field[] fields;
            for (Field field : fields = targetClass.getDeclaredFields()) {
                try {
                    fc.doWith(field);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Shouldn't be illegal to access field '" + field.getName() + "': " + ex);
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc) throws IllegalArgumentException {
        Method[] methods = clazz.getDeclaredMethods();
        for (Method method : methods) {
            try {
                mc.doWith(method);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Shouldn't be illegal to access method '" + method.getName() + "': " + ex);
            }
        }
        if (clazz.getSuperclass() != null) {
            ReflectionHelper.doWithMethods(clazz.getSuperclass(), mc);
        } else if (clazz.isInterface()) {
            for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                ReflectionHelper.doWithMethods(genericDeclaration, mc);
            }
        }
    }

    public static Object getField(Field f, Object instance) {
        Object answer = null;
        try {
            boolean shouldSetAccessible;
            boolean oldAccessible = f.isAccessible();
            boolean bl = shouldSetAccessible = !Modifier.isPublic(f.getModifiers()) && !oldAccessible;
            if (shouldSetAccessible) {
                f.setAccessible(true);
            }
            answer = f.get(instance);
            if (shouldSetAccessible) {
                f.setAccessible(oldAccessible);
            }
            return answer;
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException("Cannot get value of: " + f);
        }
    }

    public static void setField(Field f, Object instance, Object value) {
        try {
            boolean shouldSetAccessible;
            boolean oldAccessible = f.isAccessible();
            boolean bl = shouldSetAccessible = !Modifier.isPublic(f.getModifiers()) && !oldAccessible;
            if (shouldSetAccessible) {
                f.setAccessible(true);
            }
            f.set(instance, value);
            if (shouldSetAccessible) {
                f.setAccessible(oldAccessible);
            }
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException("Cannot inject value of class: " + value.getClass() + " into: " + f);
        }
    }

    public static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }

    public static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }
}

