/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab.sample.camel;

import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.converter.CorePackageScanClassResolver;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.TypeConverterRegistry;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private DefaultCamelContext camelContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = this.getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            this.startCamel();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    public void startCamel() throws Exception {
        System.out.println("Starting my Sample CamelContext");
        this.camelContext = new DefaultCamelContext();
        CorePackageScanClassResolver corePackageScanClassResolver = new CorePackageScanClassResolver();
        DefaultTypeConverter typeConverterRegistry = new DefaultTypeConverter((PackageScanClassResolver)new CorePackageScanClassResolver(), this.camelContext.getInjector(), this.camelContext.getFactoryFinder(""));
        this.camelContext.setTypeConverterRegistry((TypeConverterRegistry)typeConverterRegistry);
        this.camelContext.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("timer://foo?fixedRate=trueperiod=5000").to("velocity:transform.vm")).to("log:myFooTimer");
            }
        });
        this.camelContext.start();
    }

    public void stop(BundleContext context) throws Exception {
        this.stopCamel();
    }

    public void stopCamel() throws Exception {
        if (this.camelContext != null) {
            System.out.println("Shutting down my Sample CamelContext");
            this.camelContext.stop();
        }
    }
}

