/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config;

import io.fabric8.maven.docker.util.DeepCopy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugins.annotations.Parameter;

public class CopyConfiguration
implements Serializable {
    public static final String CONTAINER_PATH_PROPERTY = "containerPath";
    public static final String HOST_DIRECTORY_PROPERTY = "hostDirectory";
    @Parameter
    private List<Entry> entries;

    public List<Entry> getEntries() {
        return this.entries;
    }

    public List<Properties> getEntriesAsListOfProperties() {
        if (this.entries == null) {
            return null;
        }
        ArrayList<Properties> properties = new ArrayList<Properties>(this.entries.size());
        for (Entry entry : this.entries) {
            Properties entryProperties = new Properties();
            entryProperties.put(CONTAINER_PATH_PROPERTY, entry.getContainerPath());
            String hostDirectory = entry.getHostDirectory();
            if (hostDirectory != null) {
                entryProperties.put(HOST_DIRECTORY_PROPERTY, hostDirectory);
            }
            properties.add(entryProperties);
        }
        return properties;
    }

    public static class Builder {
        private final CopyConfiguration config;

        public Builder() {
            this(null);
        }

        public Builder(CopyConfiguration that) {
            this.config = that == null ? new CopyConfiguration() : DeepCopy.copy(that);
        }

        public Builder entries(List<Entry> entries) {
            ArrayList<Entry> entriesCopy = new ArrayList<Entry>(entries.size());
            for (Entry entry : entries) {
                entriesCopy.add(new Entry(entry.getContainerPath(), entry.getHostDirectory()));
            }
            this.config.entries = entriesCopy;
            return this;
        }

        public Builder entriesAsListOfProperties(List<Properties> entries) {
            this.config.entries = Builder.getEntriesFromProperties(entries);
            return this;
        }

        public CopyConfiguration build() {
            return this.config;
        }

        private static List<Entry> getEntriesFromProperties(List<Properties> properties) {
            if (properties == null) {
                return null;
            }
            ArrayList<Entry> entries = new ArrayList<Entry>(properties.size());
            int i = 0;
            for (Properties entryProperties : properties) {
                String containerPath = entryProperties.getProperty(CopyConfiguration.CONTAINER_PATH_PROPERTY);
                String hostDirectory = entryProperties.getProperty(CopyConfiguration.HOST_DIRECTORY_PROPERTY);
                if (containerPath == null && hostDirectory == null) {
                    containerPath = entryProperties.getProperty("");
                }
                if (containerPath == null) {
                    throw new IllegalArgumentException(String.format("Mandatory property [%s] of entry [%d] is not defined", CopyConfiguration.CONTAINER_PATH_PROPERTY, i));
                }
                entries.add(new Entry(containerPath, hostDirectory));
                ++i;
            }
            return entries;
        }
    }

    public static class Entry
    implements Serializable {
        private String containerPath;
        private String hostDirectory;

        public Entry() {
        }

        public Entry(String containerPath, String hostDirectory) {
            this.containerPath = containerPath;
            this.hostDirectory = hostDirectory;
        }

        public String getContainerPath() {
            return this.containerPath;
        }

        public String getHostDirectory() {
            return this.hostDirectory;
        }

        public void setContainerPath(String containerPath) {
            this.containerPath = containerPath;
        }

        public void setHostDirectory(String hostDirectory) {
            this.hostDirectory = hostDirectory;
        }
    }
}

