/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config;

import java.io.Serializable;
import java.util.Map;
import org.apache.maven.plugins.annotations.Parameter;

public class LogConfiguration
implements Serializable {
    public static final LogConfiguration DEFAULT = new LogConfiguration(null, null, null, null, null, null);
    @Parameter(defaultValue="true")
    private Boolean enabled;
    @Parameter
    private String prefix;
    @Parameter
    private String date;
    @Parameter
    private String color;
    @Parameter
    private String file;
    @Parameter
    private LogDriver driver;

    public LogConfiguration() {
    }

    private LogConfiguration(Boolean enabled, String prefix, String color, String date, String file, LogDriver driver) {
        this.enabled = enabled;
        this.prefix = prefix;
        this.date = date;
        this.color = color;
        this.file = file;
        this.driver = driver;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getDate() {
        return this.date;
    }

    public String getColor() {
        return this.color;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public boolean isActivated() {
        return this.enabled == Boolean.TRUE || this.enabled != Boolean.FALSE && !this.isBlank();
    }

    private boolean isBlank() {
        return this.prefix == null && this.date == null && this.color == null && this.file == null && this.driver == null;
    }

    public String getFileLocation() {
        return this.file;
    }

    public LogDriver getDriver() {
        return this.driver;
    }

    public static class Builder {
        private Boolean enabled;
        private String prefix;
        private String date;
        private String color;
        private String file;
        private Map<String, String> driverOpts;
        private String driverName;

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder date(String date) {
            this.date = date;
            return this;
        }

        public Builder color(String color) {
            this.color = color;
            return this;
        }

        public Builder file(String file) {
            this.file = file;
            return this;
        }

        public Builder logDriverName(String logDriver) {
            this.driverName = logDriver;
            return this;
        }

        public Builder logDriverOpts(Map<String, String> logOpts) {
            this.driverOpts = logOpts;
            return this;
        }

        public LogConfiguration build() {
            return new LogConfiguration(this.enabled, this.prefix, this.color, this.date, this.file, this.driverName != null ? new LogDriver(this.driverName, this.driverOpts) : null);
        }
    }

    public static class LogDriver
    implements Serializable {
        private String name;
        private Map<String, String> opts;

        public LogDriver() {
        }

        private LogDriver(String name, Map<String, String> opts) {
            this.name = name;
            this.opts = opts;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getOpts() {
            return this.opts;
        }
    }
}

