/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractDockerMojo;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.QueryService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.docker.util.NamePatternUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="remove", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public class RemoveMojo
extends AbstractDockerMojo {
    @Deprecated
    @Parameter(property="docker.removeAll")
    private Boolean removeAll;
    @Parameter(property="docker.removeMode")
    private String removeMode;
    @Parameter(property="docker.skip.tag", defaultValue="false")
    private boolean skipTag;
    @Parameter(property="docker.removeNamePattern")
    private String removeNamePattern;

    @Override
    protected void executeInternal(ServiceHub hub) throws DockerAccessException, MojoExecutionException {
        for (ImageConfiguration image : this.getResolvedImages()) {
            if (!this.imageShouldBeRemoved(image)) continue;
            for (String name : this.getImageNamesToRemoveForImage(hub, image)) {
                this.removeImage(hub, name);
            }
            if (this.skipTag) continue;
            for (String tag : this.getImageBuildTags(image)) {
                this.removeImage(hub, new ImageName(image.getName(), tag).getFullName());
            }
        }
        for (String name : this.getImageNamesToRemoveForMojo(hub)) {
            this.removeImage(hub, name);
        }
    }

    private boolean imageShouldBeRemoved(ImageConfiguration image) {
        if ("all".equalsIgnoreCase(this.removeMode)) {
            return true;
        }
        if ("build".equalsIgnoreCase(this.removeMode)) {
            return image.getBuildConfiguration() != null;
        }
        if ("run".equalsIgnoreCase(this.removeMode)) {
            return image.getBuildConfiguration() == null;
        }
        if ("data".equalsIgnoreCase(this.removeMode)) {
            return image.isDataImage();
        }
        if (this.removeAll != null) {
            return this.removeAll != false || image.isDataImage();
        }
        return image.getBuildConfiguration() != null;
    }

    private Collection<String> getImageNamesMatchingPattern(ServiceHub hub, Matcher imageNameMatcher) throws MojoExecutionException, DockerAccessException {
        return hub.getQueryService().listImages(false).stream().flatMap(image -> image.getRepoTags().stream()).filter(repoTag -> imageNameMatcher.reset((CharSequence)repoTag).matches()).collect(Collectors.toList());
    }

    private Collection<String> getImageNamesToRemoveForMojo(ServiceHub hub) throws MojoExecutionException, DockerAccessException {
        if (this.removeNamePattern != null) {
            Matcher imageNameMatcher = this.getImageNameMatcher(this.removeNamePattern);
            if (imageNameMatcher == null) {
                this.log.warn("There are no image name patterns in removeNamePattern for docker:remove", new Object[0]);
                return Collections.emptyList();
            }
            return this.getImageNamesMatchingPattern(hub, imageNameMatcher);
        }
        return Collections.emptyList();
    }

    private Collection<String> getImageNamesToRemoveForImage(ServiceHub hub, ImageConfiguration imageConfiguration) throws MojoExecutionException, DockerAccessException {
        if (imageConfiguration.getRemoveNamePattern() != null) {
            Matcher imageNameMatcher = this.getImageNameMatcher(imageConfiguration.getRemoveNamePattern());
            if (imageNameMatcher == null) {
                this.log.warn("There are no image name patterns in removeNamePattern for image %s: no images will be removed", imageConfiguration.getName());
                return Collections.emptyList();
            }
            return this.getImageNamesMatchingPattern(hub, imageNameMatcher);
        }
        return Collections.singleton(imageConfiguration.getName());
    }

    private Matcher getImageNameMatcher(String removeNamePattern) throws MojoExecutionException {
        try {
            String imageNameRegex = NamePatternUtil.convertNamePatternList(removeNamePattern, "image", true);
            if (imageNameRegex == null) {
                this.log.debug("No image name patterns in removeNamePattern %s", removeNamePattern);
                return null;
            }
            this.log.debug("Converted removeNamePattern %s into image name regular expression %s", removeNamePattern, imageNameRegex);
            return Pattern.compile(imageNameRegex).matcher("");
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void removeImage(ServiceHub hub, String name) throws DockerAccessException {
        QueryService queryService = hub.getQueryService();
        if (queryService.hasImage(name) && hub.getDockerAccess().removeImage(name, true)) {
            this.log.info("%s: Remove", name);
        }
    }

    private List<String> getImageBuildTags(ImageConfiguration image) {
        return image.getBuildConfiguration() != null ? image.getBuildConfiguration().getTags() : Collections.emptyList();
    }
}

