/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.wait;

import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.model.InspectedContainer;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.wait.WaitChecker;

public class HealthCheckChecker
implements WaitChecker {
    private boolean first = true;
    private DockerAccess docker;
    private String containerId;
    private Logger log;
    private final String imageConfigDesc;
    private String healthcheck;

    public HealthCheckChecker(DockerAccess docker, String containerId, String imageConfigDesc, Logger log) {
        this.docker = docker;
        this.containerId = containerId;
        this.imageConfigDesc = imageConfigDesc;
        this.log = log;
    }

    @Override
    public boolean check() {
        try {
            InspectedContainer container = this.docker.getContainer(this.containerId);
            if (container == null) {
                this.log.debug("HealthyWaitChecker: Container %s not found", new Object[0]);
                return false;
            }
            this.healthcheck = container.getHealthcheck();
            if (this.first) {
                if (this.healthcheck == null) {
                    throw new IllegalArgumentException("Can not wait for healthy state of " + this.imageConfigDesc + ". No HEALTHCHECK configured.");
                }
                this.log.info("%s: Waiting to become healthy", this.imageConfigDesc);
                this.log.debug("HealthyWaitChecker: Waiting for healthcheck: '%s'", this.healthcheck);
                this.first = false;
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("HealthyWaitChecker: Waiting on healthcheck '%s'", this.healthcheck);
            }
            return container.isHealthy();
        }
        catch (DockerAccessException e) {
            return false;
        }
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public String getLogLabel() {
        return "on healthcheck '" + this.healthcheck + "'";
    }
}

