/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractBuildSupportMojo;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.WatchMode;
import io.fabric8.maven.docker.service.BuildService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.service.WatchService;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="watch")
public class WatchMojo
extends AbstractBuildSupportMojo {
    @Parameter(property="docker.watchMode", defaultValue="both")
    private WatchMode watchMode;
    @Parameter(property="docker.watchInterval", defaultValue="5000")
    private int watchInterval;
    @Parameter(property="docker.keepRunning", defaultValue="false")
    private boolean keepRunning;
    @Parameter(property="docker.watchPostGoal")
    private String watchPostGoal;
    @Parameter(property="docker.watchPostExec")
    private String watchPostExec;
    @Parameter(property="docker.autoCreateCustomNetworks", defaultValue="false")
    protected boolean autoCreateCustomNetworks;

    @Override
    protected synchronized void executeInternal(ServiceHub hub) throws DockerAccessException, MojoExecutionException {
        BuildService.BuildContext buildContext = this.getBuildContext();
        WatchService.WatchContext watchContext = this.getWatchContext();
        hub.getWatchService().watch(watchContext, buildContext, this.getResolvedImages());
    }

    protected WatchService.WatchContext getWatchContext() throws MojoExecutionException {
        return new WatchService.WatchContext.Builder().watchInterval(this.watchInterval).watchMode(this.watchMode).watchPostGoal(this.watchPostGoal).watchPostExec(this.watchPostExec).autoCreateCustomNetworks(this.autoCreateCustomNetworks).keepContainer(this.keepContainer).keepRunning(this.keepRunning).removeVolumes(this.removeVolumes).pomLabel(this.getPomLabel()).mojoParameters(this.createMojoParameters()).build();
    }
}

