/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api;

import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import io.fabric8.docker.api.Docker;
import java.util.ArrayList;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;

public class DockerFactory {
    public static final String DEFAULT_DOCKER_HOST = "tcp://localhost:2375";
    private String address;

    public DockerFactory() {
        this.findDocker();
        this.init();
    }

    public DockerFactory(String address) {
        this.address = address;
        if (DockerFactory.isEmpty(address)) {
            this.findDocker();
        }
        this.init();
    }

    protected void findDocker() {
        this.address = DockerFactory.resolveHttpDockerHost();
    }

    private void init() {
    }

    public String toString() {
        return "DockerFactory{" + this.address + '}';
    }

    public Docker createDocker() {
        ArrayList<JacksonJaxbJsonProvider> providers = new ArrayList<JacksonJaxbJsonProvider>();
        providers.add(new JacksonJaxbJsonProvider());
        return (Docker)JAXRSClientFactory.create((String)this.address, Docker.class, providers);
    }

    public String getDockerHost() {
        String answer = this.address;
        int idx = answer.lastIndexOf(":");
        if (idx > 0) {
            answer = answer.substring(0, idx);
        }
        if ((idx = answer.lastIndexOf(":")) > 0) {
            answer = answer.substring(idx + 1);
        }
        if ((idx = answer.lastIndexOf("/")) > 0) {
            answer = answer.substring(idx + 1);
        }
        return answer;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
        if (DockerFactory.isEmpty(address)) {
            this.findDocker();
        }
    }

    protected static boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static String resolveHttpDockerHost() {
        String dockerHost = DockerFactory.resolveDockerHost();
        if (dockerHost.startsWith("tcp:")) {
            return "http:" + dockerHost.substring(4);
        }
        return dockerHost;
    }

    public static String resolveDockerHost() {
        String dockerHost = System.getenv("DOCKER_HOST");
        if (DockerFactory.isEmpty(dockerHost)) {
            dockerHost = System.getProperty("docker.host");
        }
        if (!DockerFactory.isEmpty(dockerHost)) {
            return dockerHost;
        }
        return DEFAULT_DOCKER_HOST;
    }
}

