/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils.cxf;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.cfg.Annotations;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import io.fabric8.utils.Strings;
import io.fabric8.utils.cxf.ExceptionResponseMapper;
import io.fabric8.utils.cxf.JsonHelper;
import io.fabric8.utils.cxf.TrustEverythingSSLTrustManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.ws.rs.WebApplicationException;
import net.oauth.signature.pem.PEMReader;
import net.oauth.signature.pem.PKCS1EncodedKeySpec;
import org.apache.commons.lang.ArrayUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.auth.DigestAuthSupplier;
import org.apache.cxf.transport.http.auth.HttpAuthSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebClients {
    private static final transient Logger LOG = LoggerFactory.getLogger(WebClients.class);

    public static InputStream getInputStreamFromDataOrFile(String data, File file) throws FileNotFoundException {
        if (data != null) {
            return new ByteArrayInputStream(data.getBytes());
        }
        if (file != null) {
            return new FileInputStream(file);
        }
        return null;
    }

    public static KeyStore createTrustStore(String caCertData, File caCertFile) throws Exception {
        try (InputStream pemInputStream = WebClients.getInputStreamFromDataOrFile(caCertData, caCertFile);){
            CertificateFactory certFactory = CertificateFactory.getInstance("X509");
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(pemInputStream);
            KeyStore trustStore = KeyStore.getInstance("JKS");
            trustStore.load(null);
            String alias = cert.getSubjectX500Principal().getName();
            trustStore.setCertificateEntry(alias, cert);
            KeyStore keyStore = trustStore;
            return keyStore;
        }
    }

    public static void configureCaCert(WebClient webClient, String caCertData, File caCertFile) {
        try {
            Object[] existingTrustManagers;
            KeyStore trustStore = WebClients.createTrustStore(caCertData, caCertFile);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            HTTPConduit conduit = WebClient.getConfig((Object)webClient).getHttpConduit();
            TLSClientParameters params = conduit.getTlsClientParameters();
            if (params == null) {
                params = new TLSClientParameters();
                conduit.setTlsClientParameters(params);
            }
            if (!ArrayUtils.isEmpty((Object[])(existingTrustManagers = params.getTrustManagers()))) {
                trustManagers = (TrustManager[])ArrayUtils.addAll((Object[])existingTrustManagers, (Object[])trustManagers);
            }
            params.setTrustManagers((TrustManager[])trustManagers);
        }
        catch (Exception e) {
            LOG.error("Could not create trust manager for " + caCertFile, (Throwable)e);
        }
    }

    public static void disableSslChecks(WebClient webClient) {
        HTTPConduit conduit = WebClient.getConfig((Object)webClient).getHttpConduit();
        TLSClientParameters params = conduit.getTlsClientParameters();
        if (params == null) {
            params = new TLSClientParameters();
            conduit.setTlsClientParameters(params);
        }
        params.setTrustManagers(new TrustManager[]{new TrustEverythingSSLTrustManager()});
        params.setDisableCNCheck(true);
    }

    public static void disableHostNameChecks(WebClient webClient) {
        HTTPConduit conduit = WebClient.getConfig((Object)webClient).getHttpConduit();
        TLSClientParameters params = conduit.getTlsClientParameters();
        if (params == null) {
            params = new TLSClientParameters();
            conduit.setTlsClientParameters(params);
        }
        LOG.debug("Disabling host name checks");
        params.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
    }

    public static void configureClientCert(WebClient webClient, String clientCertData, File clientCertFile, String clientKeyData, File clientKeyFile, String clientKeyAlgo, char[] clientKeyPassword) {
        try {
            Object[] existingKeyManagers;
            KeyStore keyStore = WebClients.createKeyStore(clientCertData, clientCertFile, clientKeyData, clientKeyFile, clientKeyAlgo, clientKeyPassword);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, clientKeyPassword);
            Object[] keyManagers = keyManagerFactory.getKeyManagers();
            HTTPConduit conduit = WebClient.getConfig((Object)webClient).getHttpConduit();
            TLSClientParameters params = conduit.getTlsClientParameters();
            if (params == null) {
                params = new TLSClientParameters();
                conduit.setTlsClientParameters(params);
            }
            if (!ArrayUtils.isEmpty((Object[])(existingKeyManagers = params.getKeyManagers()))) {
                keyManagers = (KeyManager[])ArrayUtils.addAll((Object[])existingKeyManagers, (Object[])keyManagers);
            }
            params.setKeyManagers((KeyManager[])keyManagers);
        }
        catch (Exception e) {
            LOG.error("Could not create key manager for " + clientCertFile + " (" + clientKeyFile + ")", (Throwable)e);
        }
    }

    public static KeyStore createKeyStore(String clientCertData, File clientCertFile, String clientKeyData, File clientKeyFile, String clientKeyAlgo, char[] clientKeyPassword) throws Exception {
        try (InputStream certInputStream = WebClients.getInputStreamFromDataOrFile(clientCertData, clientCertFile);){
            CertificateFactory certFactory = CertificateFactory.getInstance("X509");
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(certInputStream);
            InputStream keyInputStream = WebClients.getInputStreamFromDataOrFile(clientKeyData, clientKeyFile);
            PEMReader reader = new PEMReader(keyInputStream);
            RSAPrivateCrtKeySpec keySpec = new PKCS1EncodedKeySpec(reader.getDerBytes()).getKeySpec();
            KeyFactory kf = KeyFactory.getInstance(clientKeyAlgo);
            RSAPrivateKey privKey = (RSAPrivateKey)kf.generatePrivate(keySpec);
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, clientKeyPassword);
            String alias = cert.getSubjectX500Principal().getName();
            keyStore.setKeyEntry(alias, privKey, clientKeyPassword, new Certificate[]{cert});
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
    }

    public static void configureUserAndPassword(WebClient webClient, String username, String password) {
        if (Strings.isNotBlank((String)username) && Strings.isNotBlank((String)password)) {
            HTTPConduit conduit = WebClient.getConfig((Object)webClient).getHttpConduit();
            conduit.getAuthorization().setUserName(username);
            conduit.getAuthorization().setPassword(password);
        }
    }

    public static void enableDigestAuthenticaionType(WebClient webClient) {
        HTTPConduit conduit = WebClient.getConfig((Object)webClient).getHttpConduit();
        conduit.setAuthSupplier((HttpAuthSupplier)new DigestAuthSupplier());
    }

    public static List<Object> createProviders() {
        ArrayList<Object> providers = new ArrayList<Object>();
        Annotations[] annotationsToUse = JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS;
        ObjectMapper objectMapper = JsonHelper.createObjectMapper();
        providers.add(new JacksonJaxbJsonProvider(objectMapper, annotationsToUse));
        providers.add(new ExceptionResponseMapper());
        return providers;
    }

    public static <T> T handle404ByReturningNull(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (WebApplicationException e) {
            if (e.getResponse().getStatus() == 404) {
                return null;
            }
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }
}

