/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.model.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GoIntegerDeserializer
extends StdDeserializer<Integer>
implements ContextualDeserializer {
    private static final Pattern OCTAL = Pattern.compile("(0[oO]?)([0-7]+)");
    private static final GoIntegerDeserializer APPLICABLE_INSTANCE = new GoIntegerDeserializer(true);
    private static final Set<String> APPLICABLE_FIELDS = new HashSet<String>(Arrays.asList("mode", "defaultMode"));
    private final boolean applicable;

    protected GoIntegerDeserializer() {
        this(false);
    }

    private GoIntegerDeserializer(boolean applicable) {
        super(Integer.class);
        this.applicable = applicable;
    }

    @Override
    public Integer deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Matcher matcher;
        String value = p.getText();
        if (value == null) {
            return null;
        }
        if (this.applicable && (matcher = OCTAL.matcher(value)).matches()) {
            return Integer.valueOf(matcher.group(2), 8);
        }
        return this._parseInteger(ctxt, value);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        if (property != null && APPLICABLE_FIELDS.contains(property.getName())) {
            return APPLICABLE_INSTANCE;
        }
        return this;
    }
}

