/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.ListenerTLSConfig;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.SecretObjectReference;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.SecretObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.SecretObjectReferenceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ListenerTLSConfigFluent<A extends ListenerTLSConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<SecretObjectReferenceBuilder> certificateRefs = new ArrayList();
    private String mode;
    private Map<String, String> options;

    public ListenerTLSConfigFluent() {
    }

    public ListenerTLSConfigFluent(ListenerTLSConfig instance) {
        this.copyInstance(instance);
    }

    public A addAllToCertificateRefs(Collection<SecretObjectReference> items) {
        if (this.certificateRefs == null) {
            this.certificateRefs = new ArrayList();
        }
        for (SecretObjectReference item : items) {
            SecretObjectReferenceBuilder builder = new SecretObjectReferenceBuilder(item);
            this._visitables.get("certificateRefs").add(builder);
            this.certificateRefs.add(builder);
        }
        return (A)this;
    }

    public CertificateRefsNested<A> addNewCertificateRef() {
        return new CertificateRefsNested(-1, null);
    }

    public A addNewCertificateRef(String group, String kind, String name, String namespace) {
        return this.addToCertificateRefs(new SecretObjectReference(group, kind, name, namespace));
    }

    public CertificateRefsNested<A> addNewCertificateRefLike(SecretObjectReference item) {
        return new CertificateRefsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToCertificateRefs(SecretObjectReference ... items) {
        if (this.certificateRefs == null) {
            this.certificateRefs = new ArrayList();
        }
        for (SecretObjectReference item : items) {
            SecretObjectReferenceBuilder builder = new SecretObjectReferenceBuilder(item);
            this._visitables.get("certificateRefs").add(builder);
            this.certificateRefs.add(builder);
        }
        return (A)this;
    }

    public A addToCertificateRefs(int index, SecretObjectReference item) {
        if (this.certificateRefs == null) {
            this.certificateRefs = new ArrayList();
        }
        SecretObjectReferenceBuilder builder = new SecretObjectReferenceBuilder(item);
        if (index < 0 || index >= this.certificateRefs.size()) {
            this._visitables.get("certificateRefs").add(builder);
            this.certificateRefs.add(builder);
        } else {
            this._visitables.get("certificateRefs").add(builder);
            this.certificateRefs.add(index, builder);
        }
        return (A)this;
    }

    public A addToOptions(Map<String, String> map) {
        if (this.options == null && map != null) {
            this.options = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.options.putAll(map);
        }
        return (A)this;
    }

    public A addToOptions(String key, String value) {
        if (this.options == null && key != null && value != null) {
            this.options = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.options.put(key, value);
        }
        return (A)this;
    }

    public SecretObjectReference buildCertificateRef(int index) {
        return this.certificateRefs.get(index).build();
    }

    public List<SecretObjectReference> buildCertificateRefs() {
        return this.certificateRefs != null ? ListenerTLSConfigFluent.build(this.certificateRefs) : null;
    }

    public SecretObjectReference buildFirstCertificateRef() {
        return this.certificateRefs.get(0).build();
    }

    public SecretObjectReference buildLastCertificateRef() {
        return this.certificateRefs.get(this.certificateRefs.size() - 1).build();
    }

    public SecretObjectReference buildMatchingCertificateRef(Predicate<SecretObjectReferenceBuilder> predicate) {
        for (SecretObjectReferenceBuilder item : this.certificateRefs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(ListenerTLSConfig instance) {
        ListenerTLSConfig listenerTLSConfig = instance = instance != null ? instance : new ListenerTLSConfig();
        if (instance != null) {
            this.withCertificateRefs(instance.getCertificateRefs());
            this.withMode(instance.getMode());
            this.withOptions(instance.getOptions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public CertificateRefsNested<A> editCertificateRef(int index) {
        if (this.certificateRefs.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "certificateRefs"));
        }
        return this.setNewCertificateRefLike(index, this.buildCertificateRef(index));
    }

    public CertificateRefsNested<A> editFirstCertificateRef() {
        if (this.certificateRefs.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "certificateRefs"));
        }
        return this.setNewCertificateRefLike(0, this.buildCertificateRef(0));
    }

    public CertificateRefsNested<A> editLastCertificateRef() {
        int index = this.certificateRefs.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "certificateRefs"));
        }
        return this.setNewCertificateRefLike(index, this.buildCertificateRef(index));
    }

    public CertificateRefsNested<A> editMatchingCertificateRef(Predicate<SecretObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.certificateRefs.size(); ++i) {
            if (!predicate.test(this.certificateRefs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "certificateRefs"));
        }
        return this.setNewCertificateRefLike(index, this.buildCertificateRef(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ListenerTLSConfigFluent that = (ListenerTLSConfigFluent)o;
        if (!Objects.equals(this.certificateRefs, that.certificateRefs)) {
            return false;
        }
        if (!Objects.equals(this.mode, that.mode)) {
            return false;
        }
        if (!Objects.equals(this.options, that.options)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getMode() {
        return this.mode;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCertificateRefs() {
        return this.certificateRefs != null && !this.certificateRefs.isEmpty();
    }

    public boolean hasMatchingCertificateRef(Predicate<SecretObjectReferenceBuilder> predicate) {
        for (SecretObjectReferenceBuilder item : this.certificateRefs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMode() {
        return this.mode != null;
    }

    public boolean hasOptions() {
        return this.options != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.certificateRefs, this.mode, this.options, this.additionalProperties);
    }

    public A removeAllFromCertificateRefs(Collection<SecretObjectReference> items) {
        if (this.certificateRefs == null) {
            return (A)this;
        }
        for (SecretObjectReference item : items) {
            SecretObjectReferenceBuilder builder = new SecretObjectReferenceBuilder(item);
            this._visitables.get("certificateRefs").remove(builder);
            this.certificateRefs.remove(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public A removeFromCertificateRefs(SecretObjectReference ... items) {
        if (this.certificateRefs == null) {
            return (A)this;
        }
        for (SecretObjectReference item : items) {
            SecretObjectReferenceBuilder builder = new SecretObjectReferenceBuilder(item);
            this._visitables.get("certificateRefs").remove(builder);
            this.certificateRefs.remove(builder);
        }
        return (A)this;
    }

    public A removeFromOptions(String key) {
        if (this.options == null) {
            return (A)this;
        }
        if (key != null && this.options != null) {
            this.options.remove(key);
        }
        return (A)this;
    }

    public A removeFromOptions(Map<String, String> map) {
        if (this.options == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.options == null) continue;
                this.options.remove(key);
            }
        }
        return (A)this;
    }

    public A removeMatchingFromCertificateRefs(Predicate<SecretObjectReferenceBuilder> predicate) {
        if (this.certificateRefs == null) {
            return (A)this;
        }
        Iterator<SecretObjectReferenceBuilder> each = this.certificateRefs.iterator();
        Object visitables = this._visitables.get("certificateRefs");
        while (each.hasNext()) {
            SecretObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public CertificateRefsNested<A> setNewCertificateRefLike(int index, SecretObjectReference item) {
        return new CertificateRefsNested(index, item);
    }

    public A setToCertificateRefs(int index, SecretObjectReference item) {
        if (this.certificateRefs == null) {
            this.certificateRefs = new ArrayList();
        }
        SecretObjectReferenceBuilder builder = new SecretObjectReferenceBuilder(item);
        if (index < 0 || index >= this.certificateRefs.size()) {
            this._visitables.get("certificateRefs").add(builder);
            this.certificateRefs.add(builder);
        } else {
            this._visitables.get("certificateRefs").add(builder);
            this.certificateRefs.set(index, builder);
        }
        return (A)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.certificateRefs != null && !this.certificateRefs.isEmpty()) {
            sb.append("certificateRefs:");
            sb.append(this.certificateRefs);
            sb.append(",");
        }
        if (this.mode != null) {
            sb.append("mode:");
            sb.append(this.mode);
            sb.append(",");
        }
        if (this.options != null && !this.options.isEmpty()) {
            sb.append("options:");
            sb.append(this.options);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public A withCertificateRefs(List<SecretObjectReference> certificateRefs) {
        if (this.certificateRefs != null) {
            this._visitables.get("certificateRefs").clear();
        }
        if (certificateRefs != null) {
            this.certificateRefs = new ArrayList();
            for (SecretObjectReference item : certificateRefs) {
                this.addToCertificateRefs(item);
            }
        } else {
            this.certificateRefs = null;
        }
        return (A)this;
    }

    public A withCertificateRefs(SecretObjectReference ... certificateRefs) {
        if (this.certificateRefs != null) {
            this.certificateRefs.clear();
            this._visitables.remove("certificateRefs");
        }
        if (certificateRefs != null) {
            for (SecretObjectReference item : certificateRefs) {
                this.addToCertificateRefs(item);
            }
        }
        return (A)this;
    }

    public A withMode(String mode) {
        this.mode = mode;
        return (A)this;
    }

    public <K, V> A withOptions(Map<String, String> options) {
        this.options = options == null ? null : new LinkedHashMap<String, String>(options);
        return (A)this;
    }

    public class CertificateRefsNested<N>
    extends SecretObjectReferenceFluent<CertificateRefsNested<N>>
    implements Nested<N> {
        SecretObjectReferenceBuilder builder;
        int index;

        CertificateRefsNested(int index, SecretObjectReference item) {
            this.index = index;
            this.builder = new SecretObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ListenerTLSConfigFluent.this.setToCertificateRefs(this.index, this.builder.build());
        }

        public N endCertificateRef() {
            return this.and();
        }
    }
}

