/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crdv2.generator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import com.fasterxml.jackson.module.jsonSchema.types.IntegerSchema;
import com.fasterxml.jackson.module.jsonSchema.types.NumberSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ReferenceSchema;
import com.fasterxml.jackson.module.jsonSchema.types.StringSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ValueTypeSchema;
import io.fabric8.crd.generator.annotation.AdditionalPrinterColumn;
import io.fabric8.crd.generator.annotation.AdditionalSelectableField;
import io.fabric8.crd.generator.annotation.PreserveUnknownFields;
import io.fabric8.crd.generator.annotation.PrinterColumn;
import io.fabric8.crd.generator.annotation.SchemaFrom;
import io.fabric8.crd.generator.annotation.SchemaSwap;
import io.fabric8.crd.generator.annotation.SelectableField;
import io.fabric8.crdv2.generator.InternalSchemaSwaps;
import io.fabric8.crdv2.generator.KubernetesJSONSchemaProps;
import io.fabric8.crdv2.generator.KubernetesValidationRule;
import io.fabric8.crdv2.generator.ResolvingContext;
import io.fabric8.crdv2.generator.v1.JsonSchema;
import io.fabric8.crdv2.generator.v1.SchemaCustomizer;
import io.fabric8.generator.annotation.Default;
import io.fabric8.generator.annotation.Max;
import io.fabric8.generator.annotation.Min;
import io.fabric8.generator.annotation.Nullable;
import io.fabric8.generator.annotation.Pattern;
import io.fabric8.generator.annotation.Required;
import io.fabric8.generator.annotation.Size;
import io.fabric8.generator.annotation.ValidationRule;
import io.fabric8.generator.annotation.ValidationRules;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps;
import io.fabric8.kubernetes.api.model.runtime.RawExtension;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.model.annotation.LabelSelector;
import io.fabric8.kubernetes.model.annotation.SpecReplicas;
import io.fabric8.kubernetes.model.annotation.StatusReplicas;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJsonSchema<T extends KubernetesJSONSchemaProps, V extends KubernetesValidationRule> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJsonSchema.class);
    private final ResolvingContext resolvingContext;
    private final T root;
    private final Set<String> dependentClasses = new HashSet<String>();
    private final Set<AdditionalPrinterColumn> additionalPrinterColumns = new HashSet<AdditionalPrinterColumn>();
    private final Set<AdditionalSelectableField> additionalSelectableFields = new HashSet<AdditionalSelectableField>();
    private final Map<Class<? extends Annotation>, LinkedHashMap<String, AnnotationMetadata>> pathMetadata = new HashMap<Class<? extends Annotation>, LinkedHashMap<String, AnnotationMetadata>>();

    public AbstractJsonSchema(ResolvingContext resolvingContext, Class<?> def) {
        this.resolvingContext = resolvingContext;
        Stream.of(SpecReplicas.class, StatusReplicas.class, LabelSelector.class, PrinterColumn.class, SelectableField.class).forEach(clazz -> this.pathMetadata.put((Class<? extends Annotation>)clazz, new LinkedHashMap()));
        this.root = this.resolveRoot(def);
    }

    public T getSchema() {
        return this.root;
    }

    public Set<String> getDependentClasses() {
        return this.dependentClasses;
    }

    public Optional<String> getSinglePath(Class<? extends Annotation> clazz) {
        return Optional.ofNullable(this.pathMetadata.get(clazz)).flatMap(m -> m.keySet().stream().findFirst());
    }

    public Map<String, AnnotationMetadata> getAllPaths(Class<? extends Annotation> clazz) {
        return Optional.ofNullable(this.pathMetadata.get(clazz)).orElse(new LinkedHashMap());
    }

    private T resolveRoot(Class<?> definition) {
        InternalSchemaSwaps schemaSwaps = new InternalSchemaSwaps();
        JsonSchema schema = this.resolvingContext.toJsonSchema(definition);
        AbstractJsonSchema.consumeRepeatingAnnotation(definition, AdditionalPrinterColumn.class, this.additionalPrinterColumns::add);
        AbstractJsonSchema.consumeRepeatingAnnotation(definition, AdditionalSelectableField.class, this.additionalSelectableFields::add);
        if (schema instanceof ResolvingContext.GeneratorObjectSchema) {
            return this.resolveObject(new LinkedHashMap<String, String>(), schemaSwaps, schema, "kind", "apiVersion", "metadata");
        }
        return this.resolveProperty(new LinkedHashMap<String, String>(), schemaSwaps, null, this.resolvingContext.objectMapper.getSerializationConfig().constructType(definition), schema, null);
    }

    private static <A extends Annotation> void consumeRepeatingAnnotation(Class<?> beanClass, Class<A> annotation, Consumer<A> consumer) {
        while (beanClass != null && beanClass != Object.class) {
            Stream.of(beanClass.getAnnotationsByType(annotation)).forEach(consumer);
            beanClass = beanClass.getSuperclass();
        }
    }

    Optional<Field> getFieldForMethod(BeanProperty beanProperty) {
        AnnotatedElement annotated = beanProperty.getMember().getAnnotated();
        if (annotated instanceof Method) {
            Method m = (Method)annotated;
            Object name = m.getName();
            if (((String)name).startsWith("get") || ((String)name).startsWith("set")) {
                name = ((String)name).substring(3);
            } else if (((String)name).startsWith("is")) {
                name = ((String)name).substring(2);
            }
            if (!((String)name).isEmpty()) {
                name = Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1);
            }
            try {
                return Optional.of(m.getDeclaringClass().getDeclaredField((String)name));
            }
            catch (NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    void collectValidationRules(BeanProperty beanProperty, List<V> validationRules) {
        AnnotatedElement member = beanProperty.getMember().getAnnotated();
        if (member instanceof Method) {
            Optional<Field> field = this.getFieldForMethod(beanProperty);
            try {
                field.map(f -> f.getAnnotation(ValidationRule.class)).map(this::from).ifPresent(validationRules::add);
                field.map(f -> f.getAnnotation(ValidationRules.class)).ifPresent(ann -> Stream.of(ann.value()).map(this::from).forEach(validationRules::add));
            }
            catch (SecurityException securityException) {
            }
            Stream.of((ValidationRule[])member.getAnnotationsByType(ValidationRule.class)).map(this::from).forEach(validationRules::add);
            return;
        }
        Optional.ofNullable(beanProperty.getAnnotation(ValidationRule.class)).map(this::from).ifPresent(validationRules::add);
        Optional.ofNullable(beanProperty.getAnnotation(ValidationRules.class)).ifPresent(ann -> Stream.of(ann.value()).map(this::from).forEach(validationRules::add));
    }

    private T resolveObject(LinkedHashMap<String, String> visited, InternalSchemaSwaps schemaSwaps, JsonSchema jacksonSchema, String ... ignore) {
        LinkedHashSet<String> ignores = ignore.length > 0 ? new LinkedHashSet<String>(Arrays.asList(ignore)) : Collections.emptySet();
        Object objectSchema = this.singleProperty("object");
        InternalSchemaSwaps swaps = schemaSwaps = schemaSwaps.branchAnnotations();
        ResolvingContext.GeneratorObjectSchema gos = (ResolvingContext.GeneratorObjectSchema)jacksonSchema.asObjectSchema();
        BeanDescription bd = this.resolvingContext.objectMapper.getSerializationConfig().introspect(gos.javaType);
        boolean preserveUnknownFields = false;
        if (this.resolvingContext.implicitPreserveUnknownFields) {
            preserveUnknownFields = bd.findAnyGetter() != null || bd.findAnySetterAccessor() != null;
        }
        Class<?> rawClass = gos.javaType.getRawClass();
        this.collectDependentClasses(rawClass);
        AbstractJsonSchema.consumeRepeatingAnnotation(rawClass, PreserveUnknownFields.class, ignored -> objectSchema.setXKubernetesPreserveUnknownFields(true));
        AbstractJsonSchema.consumeRepeatingAnnotation(rawClass, SchemaSwap.class, ss -> swaps.registerSwap(rawClass, ss.originalType(), ss.fieldName(), ss.targetType(), ss.depth()));
        ArrayList<String> required = new ArrayList<String>();
        for (Map.Entry<String, JsonSchema> property : new TreeMap<String, JsonSchema>(gos.getProperties()).entrySet()) {
            String name = property.getKey();
            if (ignores.contains(name)) continue;
            schemaSwaps = schemaSwaps.branchDepths();
            InternalSchemaSwaps.SwapResult swapResult = schemaSwaps.lookupAndMark(rawClass, name);
            LinkedHashMap<String, String> savedVisited = visited;
            if (swapResult.onGoing) {
                visited = new LinkedHashMap();
            }
            BeanProperty beanProperty = gos.beanProperties.get(property.getKey());
            Utils.checkNotNull(beanProperty, "CRD generation works only with bean properties");
            if (beanProperty.getAnnotation(JsonIgnore.class) != null) continue;
            JsonSchema propertySchema = property.getValue();
            PropertyMetadata propertyMetadata = new PropertyMetadata(propertySchema, beanProperty);
            if (propertyMetadata.required) {
                required.add(name);
            }
            JavaType type = beanProperty.getType();
            if (swapResult.classRef != null) {
                propertyMetadata.schemaFrom = swapResult.classRef;
            }
            if (propertyMetadata.schemaFrom != null) {
                if (propertyMetadata.schemaFrom == Void.TYPE) continue;
                propertySchema = this.resolvingContext.toJsonSchema(propertyMetadata.schemaFrom);
                type = this.resolvingContext.objectMapper.getSerializationConfig().constructType(propertyMetadata.schemaFrom);
            }
            Object schema = this.resolveProperty(visited, schemaSwaps, name, type, propertySchema, beanProperty);
            propertyMetadata.updateSchema(schema);
            if (!swapResult.onGoing) {
                for (Map.Entry<Class<? extends Annotation>, LinkedHashMap<String, AnnotationMetadata>> entry : this.pathMetadata.entrySet()) {
                    Optional.ofNullable(beanProperty.getAnnotation(entry.getKey())).ifPresent(ann -> ((LinkedHashMap)entry.getValue()).put(AbstractJsonSchema.toFQN(savedVisited, name), new AnnotationMetadata((Annotation)ann, (KubernetesJSONSchemaProps)schema)));
                }
            }
            visited = savedVisited;
            this.addProperty(name, objectSchema, schema);
        }
        swaps.throwIfUnmatchedSwaps();
        objectSchema.setRequired(required);
        if (preserveUnknownFields) {
            objectSchema.setXKubernetesPreserveUnknownFields(true);
        }
        ArrayList validationRules = new ArrayList();
        AbstractJsonSchema.consumeRepeatingAnnotation(rawClass, ValidationRule.class, v -> validationRules.add(this.from((ValidationRule)v)));
        this.addToValidationRules(objectSchema, validationRules);
        return this.handleSchemaCustomizer(objectSchema, rawClass);
    }

    private T handleSchemaCustomizer(T objectSchema, Class<?> rawClass) {
        if (objectSchema instanceof JSONSchemaProps) {
            JSONSchemaProps[] props = new JSONSchemaProps[]{(JSONSchemaProps)objectSchema};
            AbstractJsonSchema.consumeRepeatingAnnotation(rawClass, SchemaCustomizer.class, sc -> {
                try {
                    props[0] = sc.value().getConstructor(new Class[0]).newInstance(new Object[0]).apply(props[0], sc.input(), this.resolvingContext.kubernetesSerialization);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException("Failed to instantiate or apply SchemaCustomizer: " + sc.value().getName(), e);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("Failed to apply SchemaCustomizer: " + sc.value().getName(), e);
                }
            });
            if (props[0] != objectSchema) {
                objectSchema = this.resolvingContext.kubernetesSerialization.convertValue(props[0], JsonSchema.V1JSONSchemaProps.class);
            }
        }
        return objectSchema;
    }

    private void collectDependentClasses(Class<?> rawClass) {
        if (rawClass != null && !rawClass.getName().startsWith("java.") && this.dependentClasses.add(rawClass.getName())) {
            Stream.of(rawClass.getInterfaces()).forEach(this::collectDependentClasses);
            this.collectDependentClasses(rawClass.getSuperclass());
        }
    }

    static String toFQN(LinkedHashMap<String, String> visited, String name) {
        if (visited.isEmpty()) {
            return "." + name;
        }
        return visited.values().stream().collect(Collectors.joining(".", ".", ".")) + name;
    }

    private T resolveProperty(LinkedHashMap<String, String> visited, InternalSchemaSwaps schemaSwaps, String name, JavaType type, JsonSchema jacksonSchema, BeanProperty beanProperty) {
        if (jacksonSchema.isArraySchema()) {
            ArraySchema.Items items = jacksonSchema.asArraySchema().getItems();
            if (items == null) {
                throw new IllegalStateException(String.format("Untyped collection %s", name));
            }
            if (items.isArrayItems()) {
                throw new IllegalStateException("not yet supported");
            }
            JsonSchema arraySchema = jacksonSchema.asArraySchema().getItems().asSingleItems().getSchema();
            T schema = this.resolveProperty(visited, schemaSwaps, name, type.getContentType(), arraySchema, null);
            this.handleTypeAnnotations(schema, beanProperty, List.class, 0);
            return this.arrayLikeProperty(schema);
        }
        if (jacksonSchema.isIntegerSchema()) {
            return this.singleProperty("integer");
        }
        if (jacksonSchema.isNumberSchema()) {
            return this.singleProperty("number");
        }
        if (jacksonSchema.isBooleanSchema()) {
            return this.singleProperty("boolean");
        }
        if (jacksonSchema.isStringSchema()) {
            StringSchema stringSchema = jacksonSchema.asStringSchema();
            if (!stringSchema.getEnums().isEmpty()) {
                Set ignores = type.isEnumType() ? this.findIgnoredEnumConstants(type) : Collections.emptySet();
                JsonNode[] enumValues = (JsonNode[])stringSchema.getEnums().stream().sorted().filter(s -> !ignores.contains(s)).map(JsonNodeFactory.instance::textNode).toArray(JsonNode[]::new);
                return this.enumProperty(enumValues);
            }
            return this.singleProperty("string");
        }
        if (jacksonSchema.isNullSchema()) {
            return this.singleProperty("object");
        }
        if (jacksonSchema.isAnySchema()) {
            if (type.getRawClass() == IntOrString.class || type.getRawClass() == Quantity.class) {
                return this.intOrString();
            }
            if (type.getRawClass() == RawExtension.class) {
                return this.raw();
            }
            String typeName = null;
            if (type.getRawClass() == ObjectNode.class) {
                typeName = "object";
            }
            T schema = this.singleProperty(typeName);
            schema.setXKubernetesPreserveUnknownFields(true);
            return schema;
        }
        if (jacksonSchema.isUnionTypeSchema()) {
            throw new IllegalStateException("not yet supported");
        }
        if (jacksonSchema instanceof ReferenceSchema) {
            ReferenceSchema ref = (ReferenceSchema)jacksonSchema;
            ResolvingContext.GeneratorObjectSchema referenced = this.resolvingContext.uriToJacksonSchema.get(ref.get$ref());
            Utils.checkNotNull(referenced, "Could not find previously generated schema");
            jacksonSchema = referenced;
        } else if (type.isMapLikeType()) {
            JavaType keyType = type.getKeyType();
            JavaType valueType = type.getContentType();
            if (keyType.getRawClass() != String.class) {
                LOGGER.warn("Property '{}' with '{}' key type is mapped to 'string' because of CRD schemas limitations", (Object)name, (Object)keyType);
            }
            JsonSchema mapValueSchema = ((ObjectSchema.SchemaAdditionalProperties)((ObjectSchema)jacksonSchema).getAdditionalProperties()).getJsonSchema();
            T component = this.resolveProperty(visited, schemaSwaps, name, valueType, mapValueSchema, null);
            this.handleTypeAnnotations(component, beanProperty, Map.class, 1);
            return this.mapLikeProperty(component);
        }
        Class<?> def = type.getRawClass();
        if (def == GenericKubernetesResource.class || def.isInterface() && HasMetadata.class.isAssignableFrom(def)) {
            return this.raw();
        }
        if (visited.put(def.getName(), name) != null) {
            throw new IllegalArgumentException("Found a cyclic reference involving the field of type " + def.getName() + " starting a field " + visited.entrySet().stream().map(e -> (String)e.getValue() + " >>\n" + (String)e.getKey()).collect(Collectors.joining(".")) + "." + name);
        }
        T res = this.resolveObject(visited, schemaSwaps, jacksonSchema, new String[0]);
        visited.remove(def.getName());
        return res;
    }

    private void handleTypeAnnotations(T schema, BeanProperty beanProperty, Class<?> containerType, int typeIndex) {
        if (beanProperty == null || !containerType.equals(beanProperty.getType().getRawClass())) {
            return;
        }
        AnnotatedElement member = beanProperty.getMember().getAnnotated();
        AnnotatedType fieldType = null;
        AnnotatedType methodType = null;
        if (member instanceof Field) {
            fieldType = ((Field)member).getAnnotatedType();
        } else if (member instanceof Method) {
            fieldType = this.getFieldForMethod(beanProperty).map(Field::getAnnotatedType).orElse(null);
            methodType = ((Method)member).getAnnotatedReceiverType();
        }
        Stream.of(fieldType, methodType).filter(o -> !Objects.isNull(o)).filter(AnnotatedParameterizedType.class::isInstance).map(AnnotatedParameterizedType.class::cast).map(AnnotatedParameterizedType::getAnnotatedActualTypeArguments).map(a -> a[typeIndex]).forEach(at -> {
            if ("string".equals(schema.getType())) {
                Optional.ofNullable(at.getAnnotation(Pattern.class)).ifPresent(a -> schema.setPattern(a.value()));
                Optional.ofNullable(at.getAnnotation(Size.class)).map(Size::min).filter(v -> v > 0L).ifPresent(schema::setMinLength);
                Optional.ofNullable(at.getAnnotation(Size.class)).map(Size::max).filter(v -> v < Long.MAX_VALUE).ifPresent(schema::setMaxLength);
            } else if ("number".equals(schema.getType()) || "integer".equals(schema.getType())) {
                Optional.ofNullable(at.getAnnotation(Min.class)).ifPresent(a -> {
                    schema.setMinimum(a.value());
                    if (!a.inclusive()) {
                        schema.setExclusiveMinimum(true);
                    }
                });
                Optional.ofNullable(at.getAnnotation(Max.class)).ifPresent(a -> {
                    schema.setMaximum(a.value());
                    if (!a.inclusive()) {
                        schema.setExclusiveMaximum(true);
                    }
                });
            }
        });
    }

    private Set<String> findIgnoredEnumConstants(JavaType type) {
        Field[] fields = type.getRawClass().getFields();
        HashSet<String> toIgnore = new HashSet<String>();
        for (Field field : fields) {
            if (!field.isEnumConstant() || field.getAnnotation(JsonIgnore.class) == null) continue;
            try {
                Object value = field.get(null);
                toIgnore.add(this.resolvingContext.objectMapper.convertValue(value, String.class));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return toIgnore;
    }

    V from(ValidationRule validationRule) {
        V result = this.newKubernetesValidationRule();
        result.setRule(validationRule.value());
        result.setReason(AbstractJsonSchema.mapNotEmpty(validationRule.reason()));
        result.setMessage(AbstractJsonSchema.mapNotEmpty(validationRule.message()));
        result.setMessageExpression(AbstractJsonSchema.mapNotEmpty(validationRule.messageExpression()));
        result.setFieldPath(AbstractJsonSchema.mapNotEmpty(validationRule.fieldPath()));
        result.setOptionalOldSelf(validationRule.optionalOldSelf() ? Boolean.valueOf(true) : null);
        return result;
    }

    private static String mapNotEmpty(String s) {
        return Utils.isNullOrEmpty(s) ? null : s;
    }

    protected abstract V newKubernetesValidationRule();

    protected abstract void addProperty(String var1, T var2, T var3);

    protected abstract T intOrString();

    protected abstract T arrayLikeProperty(T var1);

    protected abstract T mapLikeProperty(T var1);

    protected abstract T singleProperty(String var1);

    protected abstract T enumProperty(JsonNode ... var1);

    protected abstract void addToValidationRules(T var1, List<V> var2);

    protected abstract T raw();

    public Set<AdditionalPrinterColumn> getAdditionalPrinterColumns() {
        return this.additionalPrinterColumns;
    }

    public Set<AdditionalSelectableField> getAdditionalSelectableFields() {
        return this.additionalSelectableFields;
    }

    class PropertyMetadata {
        private boolean required;
        private final String description;
        private final JsonNode defaultValue;
        private Double min;
        private Boolean exclusiveMinimum;
        private Double max;
        private Boolean exclusiveMaximum;
        private String pattern;
        private Long minLength;
        private Long maxLength;
        private Long minItems;
        private Long maxItems;
        private Long minProperties;
        private Long maxProperties;
        private boolean nullable;
        private String format;
        private List<V> validationRules = new ArrayList();
        private boolean preserveUnknownFields;
        private Class<?> schemaFrom;

        public PropertyMetadata(JsonSchema value, BeanProperty beanProperty) {
            this.required = Boolean.TRUE.equals(value.getRequired());
            this.description = beanProperty.getMetadata().getDescription();
            this.schemaFrom = Optional.ofNullable(beanProperty.getAnnotation(SchemaFrom.class)).map(SchemaFrom::type).orElse(null);
            boolean bl = this.preserveUnknownFields = beanProperty.getAnnotation(PreserveUnknownFields.class) != null;
            if (value.isValueTypeSchema()) {
                ValueTypeSchema valueTypeSchema = value.asValueTypeSchema();
                this.format = Optional.ofNullable(valueTypeSchema.getFormat()).map(Object::toString).orElse(null);
            }
            if (value.isStringSchema()) {
                StringSchema stringSchema = value.asStringSchema();
                this.pattern = Optional.ofNullable(beanProperty.getAnnotation(Pattern.class)).map(Pattern::value).or(() -> Optional.ofNullable(stringSchema.getPattern())).orElse(null);
                this.minLength = this.findMinInSizeAnnotation(beanProperty).or(() -> Optional.ofNullable(stringSchema.getMinLength()).map(Integer::longValue)).orElse(null);
                this.maxLength = this.findMaxInSizeAnnotation(beanProperty).or(() -> Optional.ofNullable(stringSchema.getMaxLength()).map(Integer::longValue)).orElse(null);
            } else if (value.isIntegerSchema()) {
                IntegerSchema integerSchema = value.asIntegerSchema();
                this.setMinMax(beanProperty, integerSchema.getMinimum(), integerSchema.getExclusiveMinimum(), integerSchema.getMaximum(), integerSchema.getExclusiveMaximum());
            } else if (value.isNumberSchema()) {
                NumberSchema numberSchema = value.asNumberSchema();
                this.setMinMax(beanProperty, numberSchema.getMinimum(), numberSchema.getExclusiveMinimum(), numberSchema.getMaximum(), numberSchema.getExclusiveMaximum());
            } else if (value.isArraySchema()) {
                ArraySchema arraySchema = value.asArraySchema();
                this.minItems = this.findMinInSizeAnnotation(beanProperty).or(() -> Optional.ofNullable(arraySchema.getMinItems()).map(Integer::longValue)).orElse(null);
                this.maxItems = this.findMaxInSizeAnnotation(beanProperty).or(() -> Optional.ofNullable(arraySchema.getMaxItems()).map(Integer::longValue)).orElse(null);
            } else if (value.isObjectSchema()) {
                this.minProperties = this.findMinInSizeAnnotation(beanProperty).orElse(null);
                this.maxProperties = this.findMaxInSizeAnnotation(beanProperty).orElse(null);
            }
            AbstractJsonSchema.this.collectValidationRules(beanProperty, this.validationRules);
            this.nullable = beanProperty.getAnnotation(Nullable.class) != null;
            this.required = beanProperty.getAnnotation(Required.class) != null;
            this.defaultValue = this.toDefault(beanProperty);
        }

        JsonNode toDefault(BeanProperty beanProperty) {
            Optional<String> defaultAnnotationValue = Optional.ofNullable(beanProperty.getAnnotation(Default.class)).map(Default::value);
            String value = defaultAnnotationValue.orElse(beanProperty.getMetadata().getDefaultValue());
            if (value == null) {
                return null;
            }
            Optional<Class> rawType = Optional.ofNullable(beanProperty.getType()).map(JavaType::getRawClass);
            try {
                Object typedValue = AbstractJsonSchema.this.resolvingContext.kubernetesSerialization.unmarshal(value, rawType.orElse(Object.class));
                return AbstractJsonSchema.this.resolvingContext.kubernetesSerialization.convertValue(typedValue, JsonNode.class);
            }
            catch (Exception e) {
                if (defaultAnnotationValue.isEmpty()) {
                    LOGGER.warn("Cannot parse default value: '" + value + "' from JsonProperty annotation as valid YAML or JSON, no default value will be used.");
                    return null;
                }
                throw new IllegalArgumentException("Cannot parse default value: '" + value + "' as valid YAML or JSON.", e);
            }
        }

        private void setMinMax(BeanProperty beanProperty, Double minimum, Boolean exclusiveMinimum, Double maximum, Boolean exclusiveMaximum) {
            Optional.ofNullable(minimum).ifPresent(v -> {
                this.min = v;
                if (Boolean.TRUE.equals(exclusiveMinimum)) {
                    this.exclusiveMinimum = true;
                }
            });
            Optional.ofNullable(beanProperty.getAnnotation(Min.class)).ifPresent(a -> {
                this.min = a.value();
                if (!a.inclusive()) {
                    this.exclusiveMinimum = true;
                }
            });
            Optional.ofNullable(maximum).ifPresent(v -> {
                this.max = v;
                if (Boolean.TRUE.equals(exclusiveMaximum)) {
                    this.exclusiveMaximum = true;
                }
            });
            Optional.ofNullable(beanProperty.getAnnotation(Max.class)).ifPresent(a -> {
                this.max = a.value();
                if (!a.inclusive()) {
                    this.exclusiveMaximum = true;
                }
            });
        }

        public void updateSchema(T schema) {
            schema.setDescription(this.description);
            schema.setDefault(this.defaultValue);
            if (this.nullable) {
                schema.setNullable(true);
            }
            schema.setMaximum(this.max);
            schema.setExclusiveMaximum(this.exclusiveMaximum);
            schema.setMinimum(this.min);
            schema.setExclusiveMinimum(this.exclusiveMinimum);
            schema.setMinLength(this.minLength);
            schema.setMaxLength(this.maxLength);
            schema.setMinItems(this.minItems);
            schema.setMaxItems(this.maxItems);
            schema.setMinProperties(this.minProperties);
            schema.setMaxProperties(this.maxProperties);
            schema.setPattern(this.pattern);
            schema.setFormat(this.format);
            if (this.preserveUnknownFields) {
                schema.setXKubernetesPreserveUnknownFields(true);
            }
            AbstractJsonSchema.this.addToValidationRules(schema, this.validationRules);
        }

        private Optional<Long> findMinInSizeAnnotation(BeanProperty beanProperty) {
            return Optional.ofNullable(beanProperty.getAnnotation(Size.class)).map(Size::min).filter(v -> v > 0L);
        }

        private Optional<Long> findMaxInSizeAnnotation(BeanProperty beanProperty) {
            return Optional.ofNullable(beanProperty.getAnnotation(Size.class)).map(Size::max).filter(v -> v < Long.MAX_VALUE);
        }
    }

    public static class AnnotationMetadata {
        public final Annotation annotation;
        public final KubernetesJSONSchemaProps schema;

        public AnnotationMetadata(Annotation annotation, KubernetesJSONSchemaProps schema) {
            this.annotation = annotation;
            this.schema = schema;
        }
    }
}

